/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.dto.AuthParamData;
import org.apache.shenyu.common.dto.AuthPathData;

public class AppAuthData {
    private String appKey;
    private String appSecret;
    private Boolean enabled;
    private Boolean open;
    private List<AuthParamData> paramDataList;
    private List<AuthPathData> pathDataList;
    private String namespaceId;

    public AppAuthData() {
    }

    private AppAuthData(Builder builder) {
        this.appKey = builder.appKey;
        this.appSecret = builder.appSecret;
        this.enabled = builder.enabled;
        this.open = builder.open;
        this.paramDataList = builder.paramDataList;
        this.pathDataList = builder.pathDataList;
        this.namespaceId = builder.namespaceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getOpen() {
        return this.open;
    }

    public void setOpen(Boolean open) {
        this.open = open;
    }

    public List<AuthParamData> getParamDataList() {
        return this.paramDataList;
    }

    public void setParamDataList(List<AuthParamData> paramDataList) {
        this.paramDataList = paramDataList;
    }

    public List<AuthPathData> getPathDataList() {
        return this.pathDataList;
    }

    public void setPathDataList(List<AuthPathData> pathDataList) {
        this.pathDataList = pathDataList;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        AppAuthData that = (AppAuthData)o;
        return Objects.equals(this.appKey, that.appKey) && Objects.equals(this.appSecret, that.appSecret) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.open, that.open) && Objects.equals(this.paramDataList, that.paramDataList) && Objects.equals(this.pathDataList, that.pathDataList) && Objects.equals(this.namespaceId, that.namespaceId);
    }

    public int hashCode() {
        return Objects.hash(this.appKey, this.appSecret, this.enabled, this.open, this.paramDataList, this.pathDataList, this.namespaceId);
    }

    public String toString() {
        return "AppAuthData{appKey='" + this.appKey + "', appSecret='" + this.appSecret + "', enabled=" + this.enabled + ", open=" + this.open + ", paramDataList=" + this.paramDataList + ", pathDataList=" + this.pathDataList + ", namespaceId=" + this.namespaceId + "}";
    }

    public static final class Builder {
        private String appKey;
        private String appSecret;
        private Boolean enabled;
        private Boolean open;
        private List<AuthParamData> paramDataList;
        private List<AuthPathData> pathDataList;
        private String namespaceId;

        private Builder() {
        }

        public AppAuthData build() {
            return new AppAuthData(this);
        }

        public Builder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder open(Boolean open) {
            this.open = open;
            return this;
        }

        public Builder paramDataList(List<AuthParamData> paramDataList) {
            this.paramDataList = paramDataList;
            return this;
        }

        public Builder pathDataList(List<AuthPathData> pathDataList) {
            this.pathDataList = pathDataList;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }
    }
}

