/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.builder.CodecUtils;
import io.fury.builder.Generated;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.util.Preconditions;
import java.lang.reflect.Modifier;

public final class CodegenSerializer {
    public static boolean supportCodegenForJavaSerialization(Class<?> cls) {
        return cls.getEnclosingClass() == null || Modifier.isStatic(cls.getModifiers());
    }

    public static <T> Class<Serializer<T>> loadCodegenSerializer(Fury fury, Class<T> cls) {
        try {
            return CodecUtils.loadOrGenObjectCodecClass(cls, fury);
        }
        catch (Exception e) {
            String msg = String.format("Create sequential serializer failed, \nclass: %s", cls);
            throw new RuntimeException(msg, e);
        }
    }

    public static <T> Class<Serializer<T>> loadCompatibleCodegenSerializer(Fury fury, Class<T> cls) {
        try {
            return CodecUtils.loadOrGenCompatibleCodecClass(cls, fury);
        }
        catch (Exception e) {
            String msg = String.format("Create compatible serializer failed, \nclass: %s", cls);
            throw new RuntimeException(msg, e);
        }
    }

    public static final class LazyInitBeanSerializer<T>
    extends Serializer<T> {
        private Serializer<T> serializer;
        private Serializer<T> interpreterSerializer;

        public LazyInitBeanSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.getOrCreateGeneratedSerializer().write(buffer, value);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.getOrCreateGeneratedSerializer().read(buffer);
        }

        private Serializer<T> getOrCreateGeneratedSerializer() {
            if (this.serializer == null) {
                Serializer jitSerializer = this.fury.getClassResolver().getSerializer(this.type);
                if (jitSerializer instanceof LazyInitBeanSerializer) {
                    if (this.interpreterSerializer != null) {
                        return this.interpreterSerializer;
                    }
                    if (this.fury.getConfig().isAsyncCompilationEnabled()) {
                        Class<? extends Serializer> sc = this.fury.getClassResolver().getSerializerClass(this.type, false);
                        this.interpreterSerializer = Serializers.newSerializer(this.fury, this.type, sc);
                        return this.interpreterSerializer;
                    }
                    Class<? extends Serializer> sc = this.fury.getClassResolver().getSerializerClass(this.type);
                    Preconditions.checkArgument(Generated.GeneratedSerializer.class.isAssignableFrom(sc), "Expect jit serializer but got %s for class %s", sc, this.type);
                    this.serializer = Serializers.newSerializer(this.fury, this.type, sc);
                    this.fury.getClassResolver().setSerializer(this.type, this.serializer);
                    return this.serializer;
                }
                this.serializer = jitSerializer;
            }
            return this.serializer;
        }
    }
}

