/*
 * Decompiled with CFR 0.152.
 */
package io.fury.pool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fury.Fury;
import io.fury.pool.ClassLoaderFuryPooled;
import io.fury.util.LoaderBinding;
import io.fury.util.LoggerFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;

public class FuryPooledObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FuryPooledObjectFactory.class);
    private final Function<ClassLoader, Fury> furyFactory;
    private final Cache<ClassLoader, ClassLoaderFuryPooled> classLoaderFuryPooledCache;
    private final ThreadLocal<ClassLoader> classLoaderLocal = ThreadLocal.withInitial(() -> Thread.currentThread().getContextClassLoader());
    private final int minPoolSize;
    private final int maxPoolSize;

    public FuryPooledObjectFactory(Function<ClassLoader, Fury> furyFactory, int minPoolSize, int maxPoolSize, long expireTime, TimeUnit timeUnit) {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.furyFactory = furyFactory;
        this.classLoaderFuryPooledCache = CacheBuilder.newBuilder().weakKeys().softValues().expireAfterAccess(expireTime, timeUnit).build();
    }

    public Fury getFury() {
        try {
            ClassLoader classLoader = this.classLoaderLocal.get();
            ClassLoaderFuryPooled classLoaderFuryPooled = (ClassLoaderFuryPooled)this.classLoaderFuryPooledCache.getIfPresent((Object)classLoader);
            if (classLoaderFuryPooled == null) {
                ClassLoaderFuryPooled cache = this.getOrAddCache(classLoader);
                return cache.getFury();
            }
            return classLoaderFuryPooled.getFury();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void returnFury(Fury fury) {
        try {
            ClassLoader classLoader = this.classLoaderLocal.get();
            ClassLoaderFuryPooled classLoaderFuryPooled = (ClassLoaderFuryPooled)this.classLoaderFuryPooledCache.getIfPresent((Object)classLoader);
            if (classLoaderFuryPooled == null) {
                return;
            }
            classLoaderFuryPooled.returnFury(fury);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setClassLoader(ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
        this.classLoaderLocal.set(classLoader);
        this.getOrAddCache(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderLocal.get();
    }

    public void clearClassLoader(ClassLoader loader) {
        this.classLoaderFuryPooledCache.invalidate((Object)loader);
        this.classLoaderLocal.remove();
    }

    private synchronized ClassLoaderFuryPooled getOrAddCache(ClassLoader classLoader) {
        ClassLoaderFuryPooled classLoaderFuryPooled = (ClassLoaderFuryPooled)this.classLoaderFuryPooledCache.getIfPresent((Object)classLoader);
        if (classLoaderFuryPooled == null) {
            classLoaderFuryPooled = new ClassLoaderFuryPooled(classLoader, this.furyFactory, this.minPoolSize, this.maxPoolSize);
            this.classLoaderFuryPooledCache.put((Object)classLoader, (Object)classLoaderFuryPooled);
        }
        return classLoaderFuryPooled;
    }
}

