/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.udp;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.ConversionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.udp.Config;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;

public class UdpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(UdpHealthChecker.class);
    private FaultDetectorProto.UdpProtocolConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectResult detectInstance(Instance instance, FaultDetectorProto.FaultDetectRule faultDetectRule) throws PolarisException {
        boolean needSendData;
        String host = instance.getHost();
        int port = instance.getPort();
        FaultDetectorProto.UdpProtocolConfig curConfig = this.config;
        int timeoutMs = 1000;
        if (null != faultDetectRule && faultDetectRule.getProtocol() == FaultDetectorProto.FaultDetectRule.Protocol.UDP) {
            if (faultDetectRule.getTimeout() > 0) {
                timeoutMs = faultDetectRule.getTimeout();
            }
            if (faultDetectRule.getPort() > 0) {
                port = faultDetectRule.getPort();
            }
            curConfig = faultDetectRule.getUdpConfig();
        }
        byte[] sendBytes = null;
        int maxLength = 0;
        ArrayList<byte[]> expectRecvStrs = new ArrayList<byte[]>();
        if (null != curConfig) {
            if (StringUtils.isNotBlank(curConfig.getSend())) {
                sendBytes = ConversionUtils.anyStringToByte(curConfig.getSend());
            }
            for (String receiveStr : curConfig.getReceiveList()) {
                byte[] receiveBytes = ConversionUtils.anyStringToByte(receiveStr);
                if (receiveBytes.length > maxLength) {
                    maxLength = receiveBytes.length;
                }
                expectRecvStrs.add(receiveBytes);
            }
        }
        boolean bl = needSendData = null != sendBytes && sendBytes.length > 0;
        if (!needSendData) {
            return new DetectResult(0, 0L, RetStatus.RetSuccess);
        }
        long startTimeMillis = System.currentTimeMillis();
        try (DatagramSocket socket = null;){
            Object object;
            InetAddress inet = InetAddress.getByName(host);
            socket = new DatagramSocket();
            socket.setSoTimeout(timeoutMs);
            DatagramPacket sendPacket = new DatagramPacket(sendBytes, sendBytes.length, inet, port);
            socket.send(sendPacket);
            byte[] recvBuf = new byte[1024];
            DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
            socket.receive(recvPacket);
            socket.close();
            long delayMillis = System.currentTimeMillis() - startTimeMillis;
            byte[] recvBytes = Arrays.copyOfRange(recvBuf, 0, maxLength);
            System.out.println("[UDP] checker receive bytes " + new String(recvBytes));
            boolean found = false;
            for (byte[] expectRecvStr : expectRecvStrs) {
                byte[] recvBytesClone;
                if (!Arrays.equals(expectRecvStr, recvBytesClone = Arrays.copyOfRange(recvBytes, 0, expectRecvStr.length))) continue;
                found = true;
                break;
            }
            if (found) {
                object = new DetectResult(0, delayMillis, RetStatus.RetSuccess);
                return object;
            }
            object = new DetectResult(-1, delayMillis, RetStatus.RetFail);
            return object;
        }
    }

    @Override
    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "udp";
    }

    @Override
    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = outlierDetection.getPluginConfig(this.getName(), Config.class);
        FaultDetectorProto.UdpProtocolConfig.Builder builder = FaultDetectorProto.UdpProtocolConfig.newBuilder();
        if (null != cfg && StringUtils.isNotBlank(cfg.getSend())) {
            builder.setSend(cfg.getSend());
        }
        if (null != cfg && StringUtils.isNotBlank(cfg.getReceive())) {
            builder.addReceive(cfg.getReceive());
        }
        this.config = builder.build();
    }

    @Override
    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    @Override
    public void destroy() {
    }
}

