/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite.trigger;

import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.SliceWindow;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.TimeRange;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.CounterOptions;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.Dimension;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.TriggerCounter;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class ErrRateCounter
extends TriggerCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ErrRateCounter.class);
    private static final int BUCKET_COUNT = 10;
    private SliceWindow sliceWindow;
    private final ScheduledExecutorService executorService;
    private long metricWindowMs;
    private int minimumRequest;
    private int errorPercent;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);

    public ErrRateCounter(String ruleName, CounterOptions counterOptions) {
        super(ruleName, counterOptions);
        this.executorService = counterOptions.getExecutorService();
    }

    @Override
    protected void init() {
        LOG.info("[CircuitBreaker][Counter] errRateCounter {} initialized, resource {}", (Object)this.ruleName, (Object)this.resource);
        int interval = this.triggerCondition.getInterval();
        this.metricWindowMs = (long)interval * 1000L;
        this.errorPercent = this.triggerCondition.getErrorPercent();
        this.minimumRequest = this.triggerCondition.getMinimumRequest();
        this.sliceWindow = new SliceWindow(this.resource.toString(), 10, ErrRateCounter.getBucketIntervalMs(interval), Dimension.maxDimension.ordinal());
    }

    @Override
    public void report(boolean success) {
        if (this.suspended.get()) {
            LOG.debug("[CircuitBreaker][Counter] errRateCounter {} suspended, skip report", (Object)this.ruleName);
            return;
        }
        LOG.debug("[CircuitBreaker][Counter] errRateCounter: add requestCount 1, success {}", (Object)success);
        this.sliceWindow.addGauge(bucket -> {
            if (!success) {
                bucket.addMetric(Dimension.keyFailCount.ordinal(), 1L);
            }
            return bucket.addMetric(Dimension.keyRequestCount.ordinal(), 1L);
        });
        if (!success && this.scheduled.compareAndSet(false, true)) {
            LOG.info("[CircuitBreaker][Counter] errRateCounter: trigger error rate callback on failure, name {}", (Object)this.ruleName);
            this.executorService.schedule(new StateCheckTask(), this.metricWindowMs, TimeUnit.MILLISECONDS);
        }
    }

    private static long getBucketIntervalMs(int interval) {
        long metricWindowMs = (long)interval * 1000L;
        double bucketIntervalMs = (double)metricWindowMs / 10.0;
        return (long)Math.ceil(bucketIntervalMs);
    }

    private class StateCheckTask
    implements Runnable {
        private StateCheckTask() {
        }

        @Override
        public void run() {
            long currentTimeMs = System.currentTimeMillis();
            TimeRange timeRange = new TimeRange(currentTimeMs - ErrRateCounter.this.metricWindowMs, currentTimeMs);
            long requestCount = ErrRateCounter.this.sliceWindow.calcMetricsBothIncluded(Dimension.keyRequestCount.ordinal(), timeRange);
            LOG.info("[CircuitBreaker][Counter] errRateCounter: requestCount {}, minimumRequest {}, name {}", new Object[]{requestCount, ErrRateCounter.this.minimumRequest, ErrRateCounter.this.ruleName});
            if (requestCount < (long)ErrRateCounter.this.minimumRequest) {
                ErrRateCounter.this.scheduled.set(false);
                return;
            }
            long failCount = ErrRateCounter.this.sliceWindow.calcMetricsBothIncluded(Dimension.keyFailCount.ordinal(), timeRange);
            double failRatio = (double)failCount / (double)requestCount * 100.0;
            if (failRatio >= (double)ErrRateCounter.this.errorPercent) {
                ErrRateCounter.this.suspend();
                ErrRateCounter.this.statusChangeHandler.closeToOpen(ErrRateCounter.this.ruleName);
            }
            ErrRateCounter.this.scheduled.set(false);
        }
    }
}

