/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.flow;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.flow.DiscoveryFlow;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.api.plugin.server.CommonProviderRequest;
import com.tencent.polaris.api.plugin.server.CommonProviderResponse;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.plugin.server.TargetServer;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetServiceRuleRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterResponse;
import com.tencent.polaris.api.rpc.InstancesFuture;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.rpc.ServiceRuleResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.api.rpc.WatchInstancesRequest;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.discovery.client.flow.AsyncFlow;
import com.tencent.polaris.discovery.client.flow.CommonInstancesRequest;
import com.tencent.polaris.discovery.client.flow.CommonRuleRequest;
import com.tencent.polaris.discovery.client.flow.CommonServicesRequest;
import com.tencent.polaris.discovery.client.flow.RegisterFlow;
import com.tencent.polaris.discovery.client.flow.RegisterStateManager;
import com.tencent.polaris.discovery.client.flow.SyncFlow;
import com.tencent.polaris.discovery.client.flow.WatchFlow;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class DefaultDiscoveryFlow
implements DiscoveryFlow {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDiscoveryFlow.class);
    private static final int DEFAULT_INSTANCE_TTL = 5;
    private SDKContext sdkContext;
    private Configuration config;
    private final SyncFlow syncFlow = new SyncFlow();
    private final AsyncFlow asyncFlow = new AsyncFlow();
    private final WatchFlow watchFlow = new WatchFlow();
    private RegisterFlow registerFlow;
    private List<ServiceCallResultListener> serviceCallResultListeners;

    @Override
    public void setSDKContext(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
        this.config = sdkContext.getConfig();
        this.syncFlow.init(sdkContext.getExtensions());
        this.asyncFlow.init(this.syncFlow);
        this.watchFlow.init(sdkContext.getExtensions(), this.syncFlow);
        this.serviceCallResultListeners = ServiceCallResultListener.getServiceCallResultListeners(sdkContext);
        this.registerFlow = new RegisterFlow(sdkContext);
    }

    @Override
    public InstancesResponse getAllInstances(GetAllInstancesRequest req) {
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetAllInstances(allRequest);
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public InstancesFuture asyncGetAllInstances(GetAllInstancesRequest req) {
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetAllInstances(allRequest);
    }

    @Override
    public InstancesResponse getHealthyInstances(GetHealthyInstancesRequest req) {
        CommonInstancesRequest healthyRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetInstances(healthyRequest);
    }

    @Override
    public InstancesResponse watchInstances(WatchInstancesRequest request) {
        return null;
    }

    @Override
    public InstancesResponse unWatchInstances(WatchInstancesRequest request) {
        return null;
    }

    @Override
    public ServiceRuleResponse getServiceRule(GetServiceRuleRequest req) {
        CommonRuleRequest commonRuleRequest = new CommonRuleRequest(req, this.config);
        return this.syncFlow.commonSyncGetServiceRule(commonRuleRequest);
    }

    @Override
    public ServicesResponse getServices(GetServicesRequest req) {
        CommonServicesRequest commonServicesRequest = new CommonServicesRequest(req, this.config);
        return this.syncFlow.commonSyncGetServices(commonServicesRequest);
    }

    @Override
    public InstanceRegisterResponse register(InstanceRegisterRequest req) {
        if (!req.isAutoHeartbeat()) {
            return this.doRegister(req, null);
        }
        if (req.getTtl() == null) {
            req.setTtl(5);
        }
        return this.registerFlow.registerInstance(req, this::doRegister, this::heartbeat);
    }

    private InstanceRegisterResponse doRegister(InstanceRegisterRequest req, Map<String, String> customHeader) {
        this.enrichInstanceLocation(req);
        ServerConnector serverConnector = this.sdkContext.getExtensions().getServerConnector();
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        long timeout2 = this.getTimeout(req);
        while (timeout2 > 0L) {
            long start = System.currentTimeMillis();
            ServiceCallResult serviceCallResult = new ServiceCallResult();
            CommonProviderRequest request = req.getRequest();
            try {
                CommonProviderResponse response = serverConnector.registerInstance(request, customHeader);
                LOG.info("register {}/{} instance {} succ", new Object[]{req.getNamespace(), req.getService(), response.getInstanceID()});
                serviceCallResult.setRetStatus(RetStatus.RetSuccess);
                serviceCallResult.setRetCode(ErrorCode.Success.getCode());
                InstanceRegisterResponse instanceRegisterResponse = new InstanceRegisterResponse(response.getInstanceID(), response.isExists());
                return instanceRegisterResponse;
            }
            catch (PolarisException e) {
                serviceCallResult.setRetStatus(RetStatus.RetFail);
                serviceCallResult.setRetCode(this.exceptionToErrorCode(e).getCode());
                if (e instanceof RetriableException) {
                    LOG.warn("instance register request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted(retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                long delay = System.currentTimeMillis() - start;
                serviceCallResult.setDelay(delay);
                this.reportServerCall(serviceCallResult, request.getTargetServer(), "register");
                timeout2 -= delay;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "instance register request timeout.");
    }

    @Override
    public void deRegister(InstanceDeregisterRequest req) {
        RegisterStateManager.removeRegisterState(this.sdkContext, req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        long timeout2 = this.getTimeout(req);
        ServerConnector serverConnector = this.sdkContext.getExtensions().getServerConnector();
        while (timeout2 > 0L) {
            long start = System.currentTimeMillis();
            ServiceCallResult serviceCallResult = new ServiceCallResult();
            CommonProviderRequest request = req.getRequest();
            try {
                serverConnector.deregisterInstance(request);
                serviceCallResult.setRetStatus(RetStatus.RetSuccess);
                serviceCallResult.setRetCode(ErrorCode.Success.getCode());
                LOG.info("deregister instance {} succ", (Object)req);
                return;
            }
            catch (PolarisException e) {
                serviceCallResult.setRetStatus(RetStatus.RetFail);
                serviceCallResult.setRetCode(this.exceptionToErrorCode(e).getCode());
                if (e instanceof RetriableException) {
                    LOG.warn("instance deregister request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted(retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                long delay = System.currentTimeMillis() - start;
                serviceCallResult.setDelay(delay);
                this.reportServerCall(serviceCallResult, request.getTargetServer(), "deRegister");
                timeout2 -= delay;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "instance deregister request timeout.");
    }

    @Override
    public void heartbeat(InstanceHeartbeatRequest req) {
        long timeout2 = this.getTimeout(req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        ServerConnector serverConnector = this.sdkContext.getExtensions().getServerConnector();
        while (timeout2 > 0L) {
            long start = System.currentTimeMillis();
            ServiceCallResult serviceCallResult = new ServiceCallResult();
            CommonProviderRequest request = req.getRequest();
            request.setTimeoutMs(timeout2);
            try {
                serverConnector.heartbeat(request);
                serviceCallResult.setRetStatus(RetStatus.RetSuccess);
                serviceCallResult.setRetCode(ErrorCode.Success.getCode());
                return;
            }
            catch (PolarisException e) {
                serviceCallResult.setRetStatus(RetStatus.RetFail);
                serviceCallResult.setRetCode(this.exceptionToErrorCode(e).getCode());
                if (e instanceof RetriableException) {
                    LOG.warn("heartbeat request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted(retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                long delay = System.currentTimeMillis() - start;
                serviceCallResult.setDelay(delay);
                this.reportServerCall(serviceCallResult, request.getTargetServer(), "heartbeat");
                timeout2 -= delay;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "heartbeat request timeout.");
    }

    private void enrichInstanceLocation(InstanceRegisterRequest request) {
        if (!StringUtils.isAllEmpty(request.getRegion(), request.getZone(), request.getCampus())) {
            return;
        }
        request.setRegion((String)this.sdkContext.getValueContext().getValue(LocationLevel.region.name()));
        request.setZone((String)this.sdkContext.getValueContext().getValue(LocationLevel.zone.name()));
        request.setCampus((String)this.sdkContext.getValueContext().getValue(LocationLevel.campus.name()));
    }

    private long getTimeout(RequestBaseEntity entity) {
        return entity.getTimeoutMs() == 0L ? this.sdkContext.getConfig().getGlobal().getAPI().getTimeout() : entity.getTimeoutMs();
    }

    private ErrorCode exceptionToErrorCode(Exception exception) {
        if (exception instanceof PolarisException) {
            return ((PolarisException)exception).getCode();
        }
        return ErrorCode.INTERNAL_ERROR;
    }

    private void reportInvokeStat(ServiceCallResult req) throws PolarisException {
        for (ServiceCallResultListener listener : this.serviceCallResultListeners) {
            listener.onServiceCallResult(req);
        }
    }

    public void reportServerCall(ServiceCallResult serviceCallResult, TargetServer targetServer, String method) {
        if (null != targetServer) {
            serviceCallResult.setNamespace(targetServer.getServiceKey().getNamespace());
            serviceCallResult.setService(targetServer.getServiceKey().getService());
            serviceCallResult.setHost(targetServer.getHost());
            serviceCallResult.setPort(targetServer.getPort());
            serviceCallResult.setLabels(targetServer.getLabels());
        }
        serviceCallResult.setMethod(method);
        this.reportInvokeStat(serviceCallResult);
    }

    @Override
    public void destroy() {
        if (this.registerFlow != null) {
            this.registerFlow.destroy();
        }
    }
}

