/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.Node;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceInstancesWrap
implements ServiceInstances {
    private final ServiceInstances serviceInstances;
    private List<Instance> instances;
    private int totalWeight;
    private int hashCode;

    public ServiceInstancesWrap(ServiceInstances serviceInstances, List<Instance> instances, int totalWeight) {
        this.totalWeight = totalWeight;
        this.serviceInstances = serviceInstances;
        this.instances = null == instances ? serviceInstances.getInstances() : instances;
        this.hashCode = Objects.hash(serviceInstances.getServiceKey(), instances);
    }

    @Override
    public ServiceKey getServiceKey() {
        return this.serviceInstances.getServiceKey();
    }

    @Override
    public int getTotalWeight() {
        return this.totalWeight;
    }

    public void reloadTotalWeight() {
        this.totalWeight = 0;
        if (CollectionUtils.isEmpty(this.instances)) {
            return;
        }
        for (Instance instance : this.instances) {
            this.totalWeight += instance.getWeight();
        }
    }

    @Override
    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<Instance> instances) {
        this.instances = instances;
        this.hashCode = Objects.hash(this.serviceInstances.getServiceKey(), this.instances);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String getRevision() {
        return this.serviceInstances.getRevision();
    }

    @Override
    public Instance getInstance(Node node) {
        throw new UnsupportedOperationException("getInstance not supported in ServiceInstancesWrap");
    }

    @Override
    public Instance getInstance(String id) {
        throw new UnsupportedOperationException("getInstance not supported in ServiceInstancesWrap");
    }

    @Override
    public String getService() {
        return this.serviceInstances.getService();
    }

    @Override
    public String getNamespace() {
        return this.serviceInstances.getNamespace();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.serviceInstances.getMetadata();
    }

    public List<Instance> getAllInstances() {
        return this.serviceInstances.getInstances();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInstances that = (ServiceInstances)o;
        return Objects.equals(this.serviceInstances.getServiceKey(), that.getServiceKey()) && Objects.equals(this.instances, that.getInstances());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ServiceInstancesWrap{service=" + this.serviceInstances.getServiceKey() + ", totalWeight=" + this.totalWeight + ", instances=" + this.instances + '}';
    }
}

