/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.response;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ShenyuMcpResponseDecorator
extends ServerHttpResponseDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuMcpResponseDecorator.class);
    private final StringBuilder body = new StringBuilder();
    private final CompletableFuture<String> future;
    private final String sessionId;
    private boolean isFirstChunk = true;
    private final JsonObject responseTemplate;

    public ShenyuMcpResponseDecorator(ServerHttpResponse response, String sessionId, CompletableFuture<String> future, JsonObject responseTemplate) {
        super(response);
        this.sessionId = sessionId;
        this.future = future;
        this.responseTemplate = responseTemplate;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        LOG.debug("Writing response data for session: {}", (Object)this.sessionId);
        return super.writeWith((Publisher)Flux.from(body).doOnNext(buffer -> {
            byte[] bytes = new byte[buffer.readableByteCount()];
            buffer.read(bytes);
            String chunk = new String(bytes, StandardCharsets.UTF_8);
            if (this.isFirstChunk) {
                LOG.debug("First response chunk received for session: {}", (Object)this.sessionId);
                this.isFirstChunk = false;
            }
            LOG.debug("Received response chunk for session {}, length: {}", (Object)this.sessionId, (Object)chunk.length());
            Object object = this.body;
            synchronized (object) {
                this.body.append(chunk);
            }
            if (!this.future.isDone()) {
                object = this.future;
                synchronized (object) {
                    if (!this.future.isDone()) {
                        this.future.complete(this.applyResponseTemplate(this.body.toString()));
                    }
                }
            }
        }));
    }

    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        LOG.debug("Writing and flushing response data for session: {}", (Object)this.sessionId);
        return super.writeAndFlushWith(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> setComplete() {
        String responseBody;
        LOG.debug("Response completed for session: {}", (Object)this.sessionId);
        Object object = this.body;
        synchronized (object) {
            responseBody = this.body.toString();
        }
        LOG.debug("Final response body length for session {}: {}", (Object)this.sessionId, (Object)responseBody.length());
        if (!this.future.isDone()) {
            object = this.future;
            synchronized (object) {
                if (!this.future.isDone()) {
                    this.future.complete(this.applyResponseTemplate(responseBody));
                }
            }
        }
        return super.setComplete();
    }

    private String applyResponseTemplate(String responseBody) {
        if (Objects.isNull(this.responseTemplate)) {
            return responseBody;
        }
        if (this.responseTemplate.has("body")) {
            String field;
            String template = this.responseTemplate.get("body").getAsString();
            if ("{{.}}".equals(template)) {
                return responseBody;
            }
            if (template.startsWith("{{.") && template.endsWith("}}") && !(field = template.substring(3, template.length() - 2).trim()).isEmpty()) {
                try {
                    JsonElement json = JsonParser.parseString((String)responseBody);
                    if (json.isJsonObject() && json.getAsJsonObject().has(field)) {
                        return json.getAsJsonObject().get(field).toString();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse response body as JSON or extract field '{}': {}", (Object)field, (Object)e.getMessage());
                }
            }
        }
        return responseBody;
    }
}

