/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.loadbalancer.ringhash;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.IdAwarePlugin;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.plugins.loadbalancer.ringhash.HashStrategy;
import com.tencent.polaris.plugins.loadbalancer.ringhash.MurmurHash;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConsistentHashLoadBalance
extends Destroyable
implements LoadBalancer,
IdAwarePlugin {
    private static final int VIRTUAL_NODE_SIZE = 5;
    private static final String VIRTUAL_NODE_SUFFIX = "&&";
    private int id;
    private HashStrategy hashStrategy;
    private FlowCache flowCache;

    @Override
    public Instance chooseInstance(Criteria criteria, ServiceInstances instances) throws PolarisException {
        if (instances == null || CollectionUtils.isEmpty(instances.getInstances())) {
            return null;
        }
        TreeMap ring = this.flowCache.loadPluginCacheObject(this.getId(), instances, obj -> this.buildConsistentHashRing((ServiceInstances)obj));
        int invocationHashCode = this.hashStrategy.getHashCode(criteria.getHashKey());
        return this.lookup(ring, invocationHashCode);
    }

    @Override
    public String getName() {
        return "ringHash";
    }

    @Override
    public PluginType getType() {
        return PluginTypes.LOAD_BALANCER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        this.hashStrategy = new MurmurHash();
    }

    @Override
    public void postContextInit(Extensions ctx) throws PolarisException {
        this.flowCache = ctx.getFlowCache();
    }

    private Instance lookup(TreeMap<Integer, Instance> ring, int invocationHashCode) {
        Map.Entry<Integer, Instance> locateEntry = ring.ceilingEntry(invocationHashCode);
        if (locateEntry == null) {
            locateEntry = ring.firstEntry();
        }
        return locateEntry.getValue();
    }

    private TreeMap<Integer, Instance> buildConsistentHashRing(ServiceInstances serviceInstances) {
        List<Instance> instances = serviceInstances.getInstances();
        TreeMap<Integer, Instance> virtualNodeRing = new TreeMap<Integer, Instance>();
        for (Instance instance : instances) {
            for (int i = 0; i < 5; ++i) {
                virtualNodeRing.put(this.hashStrategy.getHashCode(instance.getHost() + ":" + instance.getPort() + VIRTUAL_NODE_SUFFIX + i), instance);
            }
        }
        return virtualNodeRing;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }
}

