/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.utils;

import com.tencent.polaris.logging.LoggerFactory;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.slf4j.Logger;

public class ConversionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConversionUtils.class);
    private static final String HEX_FLAG = "0x";
    private static final String OCT_FLAG = "0o";
    private static final String DEC_FLAG = "0d";
    private static final String BIN_FLAG = "0b";

    public static byte[] anyStringToByte(String value) {
        if (value.startsWith(HEX_FLAG)) {
            return ConversionUtils.hexStringToByte(value.substring(2));
        }
        if (value.startsWith(OCT_FLAG)) {
            return ConversionUtils.octStringToByte(value.substring(2));
        }
        if (value.startsWith(DEC_FLAG)) {
            return ConversionUtils.decStringToByte(value.substring(2));
        }
        if (value.startsWith(BIN_FLAG)) {
            return ConversionUtils.binaryStringToByte(value.substring(2));
        }
        return value.getBytes();
    }

    public static byte[] hexStringToByte(String hex) {
        try {
            int i = Integer.parseInt(hex, 16);
            return ConversionUtils.bigIntToByteArray(i);
        }
        catch (Exception e) {
            LOG.error("fail to convert hex to byte", (Throwable)e);
            return null;
        }
    }

    public static byte[] decStringToByte(String hex) {
        try {
            int i = Integer.parseInt(hex, 10);
            return ConversionUtils.bigIntToByteArray(i);
        }
        catch (Exception e) {
            LOG.error("fail to convert hex to byte", (Throwable)e);
            return null;
        }
    }

    public static byte[] octStringToByte(String hex) {
        try {
            int i = Integer.parseInt(hex, 8);
            return ConversionUtils.bigIntToByteArray(i);
        }
        catch (Exception e) {
            LOG.error("fail to convert hex to byte", (Throwable)e);
            return null;
        }
    }

    public static byte[] binaryStringToByte(String hex) {
        try {
            int i = Integer.parseInt(hex, 2);
            return ConversionUtils.bigIntToByteArray(i);
        }
        catch (Exception e) {
            LOG.error("fail to convert hex to byte", (Throwable)e);
            return null;
        }
    }

    public static byte[] bigIntToByteArray(int i) {
        try {
            BigInteger bigInt = BigInteger.valueOf(i);
            return bigInt.toByteArray();
        }
        catch (Exception e) {
            LOG.error("fail to convert hex to byte", (Throwable)e);
            return null;
        }
    }

    private static Integer byteArrayToInt(byte[] intBytes) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(intBytes);
            return byteBuffer.getInt();
        }
        catch (Exception e) {
            LOG.error("fail to convert hex to byte", (Throwable)e);
            return null;
        }
    }

    public static String byteArrayToHexString(byte[] array) {
        Integer integer = ConversionUtils.byteArrayToInt(array);
        if (null == integer) {
            return null;
        }
        return Integer.toHexString(integer);
    }
}

