/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.client.core.shutdown.ShenyuClientShutdownHook;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.spi.ExtensionLoader;

public final class ShenyuClientRegisterRepositoryFactory {
    private static final Map<String, ShenyuClientRegisterRepository> REPOSITORY_MAP = new ConcurrentHashMap<String, ShenyuClientRegisterRepository>();

    public static Map<String, ShenyuClientRegisterRepository> getRepositoryMap() {
        return REPOSITORY_MAP;
    }

    public static ShenyuClientRegisterRepository newInstance(ShenyuRegisterCenterConfig shenyuRegisterCenterConfig) {
        if (!REPOSITORY_MAP.containsKey(shenyuRegisterCenterConfig.getRegisterType())) {
            ShenyuClientRegisterRepository result = (ShenyuClientRegisterRepository)ExtensionLoader.getExtensionLoader(ShenyuClientRegisterRepository.class).getJoin(shenyuRegisterCenterConfig.getRegisterType());
            result.init(shenyuRegisterCenterConfig);
            ShenyuClientShutdownHook.set(result, shenyuRegisterCenterConfig.getProps());
            REPOSITORY_MAP.put(shenyuRegisterCenterConfig.getRegisterType(), result);
            return result;
        }
        return REPOSITORY_MAP.get(shenyuRegisterCenterConfig.getRegisterType());
    }
}

