/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AiProxyRealKeyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyRealKeyResolver.class);
    private static final long RESOLVE_TIMEOUT_SECONDS = 2L;
    private final SelectorMapper selectorMapper;
    private final ObjectMapper objectMapper;
    private final ConcurrentHashMap<String, AtomicReference<String>> cache = new ConcurrentHashMap();
    private final Map<String, CompletableFuture<String>> inFlight = new ConcurrentHashMap<String, CompletableFuture<String>>();

    public AiProxyRealKeyResolver(SelectorMapper selectorMapper, ObjectMapper objectMapper) {
        this.selectorMapper = selectorMapper;
        this.objectMapper = objectMapper;
    }

    public Optional<String> resolveRealKey(String selectorId) {
        if (StringUtils.isBlank((CharSequence)selectorId)) {
            return Optional.empty();
        }
        AtomicReference<String> ref = this.cache.get(selectorId);
        if (Objects.nonNull(ref)) {
            String v = ref.get();
            LOG.debug("[AiProxyRealKeyResolver] cache hit selectorId={}, masked={}...", (Object)selectorId, (Object)this.mask(v));
            return Optional.ofNullable(ref.get());
        }
        CompletableFuture future = this.inFlight.computeIfAbsent(selectorId, id -> CompletableFuture.supplyAsync(() -> this.doResolve((String)id)).whenComplete((val, ex) -> {
            try {
                this.cache.put((String)id, new AtomicReference<String>((String)val));
                if (Objects.nonNull(ex)) {
                    LOG.warn("[AiProxyRealKeyResolver] resolve failed for selectorId={}: {}", id, (Object)ex.getMessage());
                } else {
                    LOG.info("[AiProxyRealKeyResolver] resolved selectorId={}, masked={}...", id, (Object)this.mask((String)val));
                }
            }
            finally {
                this.inFlight.remove(id);
            }
        }));
        try {
            return Optional.ofNullable((String)future.get(2L, TimeUnit.SECONDS));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOG.warn("[AiProxyRealKeyResolver] resolve interrupted for selectorId={}", (Object)selectorId);
            return Optional.empty();
        }
        catch (TimeoutException ex) {
            LOG.warn("[AiProxyRealKeyResolver] resolve timed out after {}s for selectorId={}", (Object)2L, (Object)selectorId);
            return Optional.empty();
        }
        catch (ExecutionException ex) {
            LOG.warn("[AiProxyRealKeyResolver] resolve failed for selectorId={}: {}", (Object)selectorId, (Object)(Objects.nonNull(ex.getCause()) ? ex.getCause().getMessage() : ex.getMessage()));
            return Optional.empty();
        }
    }

    public void invalidate(String selectorId) {
        if (StringUtils.isNotBlank((CharSequence)selectorId)) {
            this.cache.remove(selectorId);
            CompletableFuture<String> f = this.inFlight.remove(selectorId);
            if (Objects.nonNull(f)) {
                f.cancel(true);
            }
        }
    }

    public Optional<String> refresh(String selectorId) {
        this.invalidate(selectorId);
        return this.resolveRealKey(selectorId);
    }

    private String doResolve(String selectorId) {
        try {
            SelectorDO selector = this.selectorMapper.selectById(selectorId);
            if (Objects.isNull(selector) || StringUtils.isBlank((CharSequence)selector.getHandle())) {
                return null;
            }
            return this.extractApiKey(selector.getHandle());
        }
        catch (Exception e) {
            return null;
        }
    }

    private String extractApiKey(String handleJson) {
        try {
            JsonNode root = this.objectMapper.readTree(handleJson);
            JsonNode direct = root.get("apiKey");
            if (Objects.nonNull(direct) && direct.isTextual()) {
                return direct.asText();
            }
            return this.findFirstApiKey(root);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String findFirstApiKey(JsonNode node) {
        block5: {
            block4: {
                if (Objects.isNull(node)) {
                    return null;
                }
                if (!node.isObject()) break block4;
                JsonNode apiKey = node.get("apiKey");
                if (Objects.nonNull(apiKey) && apiKey.isTextual()) {
                    return apiKey.asText();
                }
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry entry = (Map.Entry)fields.next();
                    String found = this.findFirstApiKey((JsonNode)entry.getValue());
                    if (!StringUtils.isNotBlank((CharSequence)found)) continue;
                    return found;
                }
                break block5;
            }
            if (!node.isArray()) break block5;
            for (JsonNode child : node) {
                String found = this.findFirstApiKey(child);
                if (!StringUtils.isNotBlank((CharSequence)found)) continue;
                return found;
            }
        }
        return null;
    }

    private String mask(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            return "null";
        }
        return v.substring(0, Math.min(6, v.length()));
    }
}

