/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.BatchChangedEvent;
import org.apache.shenyu.admin.utils.SessionUtil;

public interface AdminDataModelChangedEventPublisher<T> {
    default public void onCreated(T data) {
        this.publish(new AdminDataModelChangedEvent(data, null, EventTypeEnum.CREATE, SessionUtil.visitorName()));
    }

    default public void onCreated(Collection<T> data) {
        this.publish(new BatchChangedEvent(data, null, EventTypeEnum.CREATE, SessionUtil.visitorName()));
    }

    default public void onUpdated(T data, T before) {
        this.publish(new AdminDataModelChangedEvent(data, before, EventTypeEnum.UPDATE, SessionUtil.visitorName()));
    }

    default public void onUpdated(Collection<T> data, Collection<T> before) {
        this.publish(new BatchChangedEvent(data, before, EventTypeEnum.UPDATE, SessionUtil.visitorName()));
    }

    default public void onDeleted(T data) {
        this.publish(new AdminDataModelChangedEvent(data, null, EventTypeEnum.DELETE, SessionUtil.visitorName()));
    }

    default public void onDeleted(Collection<T> data) {
        this.publish(new BatchChangedEvent(data, null, EventTypeEnum.DELETE, SessionUtil.visitorName()));
    }

    public void publish(AdminDataModelChangedEvent var1);
}

