/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class SelectorConditionDO
extends BaseDO {
    private static final long serialVersionUID = 756287802698140201L;
    private String selectorId;
    private String paramType;
    private String operator;
    private String paramName;
    private String paramValue;

    public SelectorConditionDO() {
    }

    public SelectorConditionDO(String selectorId, String paramType, String operator, String paramName, String paramValue) {
        this.selectorId = selectorId;
        this.paramType = paramType;
        this.operator = operator;
        this.paramName = paramName;
        this.paramValue = paramValue;
    }

    public String getSelectorId() {
        return this.selectorId;
    }

    public void setSelectorId(String selectorId) {
        this.selectorId = selectorId;
    }

    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public static SelectorConditionDOBuilder builder() {
        return new SelectorConditionDOBuilder();
    }

    public static SelectorConditionDO buildSelectorConditionDO(SelectorConditionDTO selectorConditionDTO) {
        return Optional.ofNullable(selectorConditionDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            SelectorConditionDO selectorConditionDO = SelectorConditionDO.builder().paramType(item.getParamType()).selectorId(item.getSelectorId()).operator(item.getOperator()).paramName(item.getParamName()).paramValue(((String)StringUtils.defaultIfBlank((CharSequence)item.getParamValue(), (CharSequence)"")).trim()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                selectorConditionDO.setId(UUIDUtils.getInstance().generateShortUuid());
                selectorConditionDO.setDateCreated(currentTime);
            } else {
                selectorConditionDO.setId(item.getId());
            }
            return selectorConditionDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelectorConditionDO that = (SelectorConditionDO)o;
        return Objects.equals(this.selectorId, that.selectorId) && Objects.equals(this.paramType, that.paramType) && Objects.equals(this.operator, that.operator) && Objects.equals(this.paramName, that.paramName) && Objects.equals(this.paramValue, that.paramValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.selectorId, this.paramType, this.operator, this.paramName, this.paramValue);
    }

    public static final class SelectorConditionDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String selectorId;
        private String paramType;
        private String operator;
        private String paramName;
        private String paramValue;

        private SelectorConditionDOBuilder() {
        }

        public SelectorConditionDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SelectorConditionDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public SelectorConditionDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public SelectorConditionDOBuilder selectorId(String selectorId) {
            this.selectorId = selectorId;
            return this;
        }

        public SelectorConditionDOBuilder paramType(String paramType) {
            this.paramType = paramType;
            return this;
        }

        public SelectorConditionDOBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public SelectorConditionDOBuilder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        public SelectorConditionDOBuilder paramValue(String paramValue) {
            this.paramValue = paramValue;
            return this;
        }

        public SelectorConditionDO build() {
            SelectorConditionDO selectorConditionDO = new SelectorConditionDO();
            selectorConditionDO.setId(this.id);
            selectorConditionDO.setDateCreated(this.dateCreated);
            selectorConditionDO.setDateUpdated(this.dateUpdated);
            selectorConditionDO.setSelectorId(this.selectorId);
            selectorConditionDO.setParamType(this.paramType);
            selectorConditionDO.setOperator(this.operator);
            selectorConditionDO.setParamName(this.paramName);
            selectorConditionDO.setParamValue(this.paramValue);
            return selectorConditionDO;
        }
    }
}

