/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.dto;

import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.admin.mapper.RoleMapper;
import org.apache.shenyu.admin.validation.annotation.Existed;

public class RoleDTO
implements Serializable {
    private static final long serialVersionUID = -3017693566893175737L;
    @Existed(provider=RoleMapper.class, nullOfIgnore=true, message="role is not existed")
    private @Existed(provider=RoleMapper.class, nullOfIgnore=true, message="role is not existed") String id;
    @NotBlank
    private String roleName;
    private String description;
    private List<@NotBlank String> currentPermissionIds;

    public RoleDTO() {
    }

    public RoleDTO(String id, @NotBlank String roleName, String description, List<String> currentPermissionIds) {
        this.id = id;
        this.roleName = roleName;
        this.description = description;
        this.currentPermissionIds = currentPermissionIds;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getCurrentPermissionIds() {
        return this.currentPermissionIds;
    }

    public void setCurrentPermissionIds(List<String> currentPermissionIds) {
        this.currentPermissionIds = currentPermissionIds;
    }

    public static RoleDTOBuilder builder() {
        return new RoleDTOBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleDTO)) {
            return false;
        }
        RoleDTO roleDTO = (RoleDTO)o;
        return Objects.equals(this.id, roleDTO.id) && Objects.equals(this.roleName, roleDTO.roleName) && Objects.equals(this.description, roleDTO.description) && Objects.equals(this.currentPermissionIds, roleDTO.currentPermissionIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.roleName, this.description, this.currentPermissionIds);
    }

    public static final class RoleDTOBuilder {
        private String id;
        private String roleName;
        private String description;
        private List<String> currentPermissionIds;

        private RoleDTOBuilder() {
        }

        public RoleDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RoleDTOBuilder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public RoleDTOBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RoleDTOBuilder currentPermissionIds(List<String> currentPermissionIds) {
            this.currentPermissionIds = currentPermissionIds;
            return this;
        }

        public RoleDTO build() {
            RoleDTO roleDTO = new RoleDTO();
            roleDTO.setId(this.id);
            roleDTO.setRoleName(this.roleName);
            roleDTO.setDescription(this.description);
            roleDTO.setCurrentPermissionIds(this.currentPermissionIds);
            return roleDTO;
        }
    }
}

