/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.shenyu.admin.discovery.AbstractDiscoveryProcessor;
import org.apache.shenyu.admin.discovery.listener.DataChangedEventListener;
import org.apache.shenyu.admin.discovery.listener.DiscoveryDataChangedEvent;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryHandlerDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.event.ChangedEventListener;

public class DefaultDiscoveryProcessor
extends AbstractDiscoveryProcessor {
    public DefaultDiscoveryProcessor(DiscoveryUpstreamMapper discoveryUpstreamMapper) {
        super(discoveryUpstreamMapper);
    }

    @Override
    public void createProxySelector(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        ShenyuInstanceRegisterRepository shenyuInstanceRegisterRepository = this.getShenyuDiscoveryService(discoveryHandlerDTO.getDiscoveryId());
        String key = this.buildProxySelectorKey(discoveryHandlerDTO.getListenerNode());
        if (Objects.isNull(shenyuInstanceRegisterRepository)) {
            throw new ShenyuAdminException(String.format("before start ProxySelector you need init DiscoveryId=%s", discoveryHandlerDTO.getDiscoveryId()));
        }
        if (!shenyuInstanceRegisterRepository.serviceExists(key)) {
            throw new ShenyuAdminException(String.format("shenyu discovery start watcher need you has this key %s in Discovery", key));
        }
        Set<String> cacheKey = this.getCacheKey(discoveryHandlerDTO.getDiscoveryId());
        if (Objects.nonNull(cacheKey) && cacheKey.contains(key)) {
            LOG.info("shenyu discovery has watcher key = {}", (Object)key);
            super.addDiscoverySyncDataListener(discoveryHandlerDTO, proxySelectorDTO);
            return;
        }
        DataChangedEventListener discoveryDataChangedEventListener = this.getDiscoveryDataChangedEventListener(discoveryHandlerDTO, proxySelectorDTO);
        shenyuInstanceRegisterRepository.watchInstances(key, (selectKey, selectValue, event) -> {
            if (event.equals((Object)ChangedEventListener.Event.ADDED)) {
                discoveryDataChangedEventListener.onChange(new DiscoveryDataChangedEvent(selectKey, selectValue, DiscoveryDataChangedEvent.Event.ADDED));
            } else if (event.equals((Object)ChangedEventListener.Event.UPDATED)) {
                discoveryDataChangedEventListener.onChange(new DiscoveryDataChangedEvent(selectKey, selectValue, DiscoveryDataChangedEvent.Event.UPDATED));
            } else if (event.equals((Object)ChangedEventListener.Event.DELETED)) {
                discoveryDataChangedEventListener.onChange(new DiscoveryDataChangedEvent(selectKey, selectValue, DiscoveryDataChangedEvent.Event.DELETED));
            } else {
                discoveryDataChangedEventListener.onChange(new DiscoveryDataChangedEvent(selectKey, selectValue, DiscoveryDataChangedEvent.Event.IGNORED));
            }
        });
        cacheKey.add(key);
        super.addChangedEventListener(discoveryHandlerDTO.getDiscoveryId(), discoveryDataChangedEventListener);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.PROXY_SELECTOR, DataEventTypeEnum.CREATE, Collections.singletonList(DiscoveryTransfer.INSTANCE.mapToData(proxySelectorDTO)));
        this.publishEvent(dataChangedEvent);
    }
}

