/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.BatchIdsDTO;
import org.apache.shenyu.admin.model.dto.ProxyApiKeyDTO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ProxyApiKeyQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.ProxyApiKeyVO;
import org.apache.shenyu.admin.service.AiProxyApiKeyService;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/selector/{selectorId}/ai-proxy-apikey"})
public class AiProxyApiKeyController
implements PagedController<ProxyApiKeyQuery, ProxyApiKeyVO> {
    private final AiProxyApiKeyService aiProxyApiKeyService;
    private final SelectorMapper selectorMapper;

    public AiProxyApiKeyController(AiProxyApiKeyService aiProxyApiKeyService, SelectorMapper selectorMapper) {
        this.aiProxyApiKeyService = aiProxyApiKeyService;
        this.selectorMapper = selectorMapper;
    }

    @PostMapping
    @RequiresPermissions(value={"system:aiProxyApiKey:add"})
    public ShenyuAdminResult create(@PathVariable(value="selectorId") String selectorId, @Valid @RequestBody ProxyApiKeyDTO dto) {
        int rows;
        SelectorDO selector = this.selectorMapper.selectById(selectorId);
        if (Objects.nonNull(selector)) {
            dto.setNamespaceId(selector.getNamespaceId());
        }
        if ((rows = this.aiProxyApiKeyService.create(dto, selectorId)) > 0) {
            ProxyApiKeyVO vo = this.aiProxyApiKeyService.findById(dto.getId());
            return ShenyuAdminResult.success("create success", vo);
        }
        return ShenyuAdminResult.error("parameter error");
    }

    @GetMapping
    @RequiresPermissions(value={"system:aiProxyApiKey:list"})
    public ShenyuAdminResult list(@PathVariable(value="selectorId") String selectorId, @RequestParam(value="namespaceId", required=false) String namespaceId, @RequestParam(value="currentPage") @NotNull Integer currentPage, @RequestParam(value="pageSize") @NotNull Integer pageSize, @RequestParam(value="proxyApiKey", required=false) String proxyApiKey) {
        SelectorDO selector = this.selectorMapper.selectById(selectorId);
        if (Objects.isNull(selector)) {
            return ShenyuAdminResult.error("ID NOT EXIST!");
        }
        ProxyApiKeyQuery query = new ProxyApiKeyQuery();
        query.setSelectorId(selectorId);
        query.setNamespaceId(selector.getNamespaceId());
        query.setProxyApiKey(proxyApiKey);
        query.setPageParameter(new PageParameter(currentPage, pageSize));
        CommonPager<ProxyApiKeyVO> pager = this.aiProxyApiKeyService.listByPage(query);
        return ShenyuAdminResult.success("query success", pager);
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:aiProxyApiKey:edit"})
    public ShenyuAdminResult update(@PathVariable(value="selectorId") String selectorId, @PathVariable(value="id") String id, @RequestBody ProxyApiKeyDTO dto) {
        ProxyApiKeyVO exist = this.aiProxyApiKeyService.findById(id);
        if (Objects.isNull(exist)) {
            return ShenyuAdminResult.error("ID NOT EXIST!");
        }
        if (!selectorId.equals(exist.getSelectorId())) {
            return ShenyuAdminResult.error("The proxy selector(s) does not exist");
        }
        dto.setId(id);
        int rows = this.aiProxyApiKeyService.update(dto);
        return rows > 0 ? ShenyuAdminResult.success("update success") : ShenyuAdminResult.error("parameter error");
    }

    @PostMapping(value={"/batchDelete"})
    @RequiresPermissions(value={"system:aiProxyApiKey:delete"})
    public ShenyuAdminResult batchDelete(@PathVariable(value="selectorId") String selectorId, @Valid @RequestBody BatchIdsDTO request) {
        List<String> allIds = request.getIds();
        ArrayList<String> validIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(allIds)) {
            for (String id : allIds) {
                ProxyApiKeyVO exist = this.aiProxyApiKeyService.findById(id);
                if (!Objects.nonNull(exist) || !selectorId.equals(exist.getSelectorId())) continue;
                validIds.add(id);
            }
        }
        if (validIds.isEmpty()) {
            return ShenyuAdminResult.error("The proxy selector(s) does not exist");
        }
        int rows = this.aiProxyApiKeyService.delete(validIds);
        return rows > 0 ? ShenyuAdminResult.success("delete success") : ShenyuAdminResult.error("delete fail");
    }

    @PostMapping(value={"/batchEnabled"})
    @RequiresPermissions(value={"system:aiProxyApiKey:disable"})
    public ShenyuAdminResult batchEnabled(@PathVariable(value="selectorId") String selectorId, @Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        List<String> allIds = batchCommonDTO.getIds();
        ArrayList<String> validIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(allIds)) {
            for (String id : allIds) {
                ProxyApiKeyVO exist = this.aiProxyApiKeyService.findById(id);
                if (!Objects.nonNull(exist) || !selectorId.equals(exist.getSelectorId())) continue;
                validIds.add(id);
            }
        }
        if (validIds.isEmpty()) {
            return ShenyuAdminResult.error("The proxy selector(s) does not exist");
        }
        String result = this.aiProxyApiKeyService.enabled(validIds, batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @Override
    public PageService<ProxyApiKeyQuery, ProxyApiKeyVO> pageService() {
        return this.aiProxyApiKeyService;
    }
}

