/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.expression;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypeConverter;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.AbstractStandardConversionService;

public final class SpringStandardConversionService
extends AbstractStandardConversionService {
    private static final TypeDescriptor TYPE_STRING = TypeDescriptor.valueOf(String.class);

    protected String convertToString(IExpressionContext context, Object object) {
        if (object == null) {
            return null;
        }
        TypeDescriptor objectTypeDescriptor = TypeDescriptor.forObject((Object)object);
        TypeConverter typeConverter = SpringStandardConversionService.getSpringConversionService(context);
        if (typeConverter == null || !typeConverter.canConvert(objectTypeDescriptor, TYPE_STRING)) {
            return super.convertToString(context, object);
        }
        return (String)typeConverter.convertValue(object, objectTypeDescriptor, TYPE_STRING);
    }

    protected <T> T convertOther(IExpressionContext context, Object object, Class<T> targetClass) {
        if (object == null) {
            return null;
        }
        TypeDescriptor objectTypeDescriptor = TypeDescriptor.forObject((Object)object);
        TypeDescriptor targetTypeDescriptor = TypeDescriptor.valueOf(targetClass);
        TypeConverter typeConverter = SpringStandardConversionService.getSpringConversionService(context);
        if (typeConverter == null || !typeConverter.canConvert(objectTypeDescriptor, targetTypeDescriptor)) {
            return (T)super.convertOther(context, object, targetClass);
        }
        return (T)typeConverter.convertValue(object, objectTypeDescriptor, targetTypeDescriptor);
    }

    private static TypeConverter getSpringConversionService(IExpressionContext context) {
        EvaluationContext evaluationContext = (EvaluationContext)context.getVariable("thymeleaf::EvaluationContext");
        if (evaluationContext != null) {
            return evaluationContext.getTypeConverter();
        }
        return null;
    }
}

