/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.integration.annotation.EndpointId;
import org.springframework.integration.annotation.Payloads;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public final class MessagingAnnotationUtils {
    public static <T> T resolveAttribute(List<Annotation> annotations, String name, Class<T> requiredType) {
        for (Annotation annotation : annotations) {
            Object value = AnnotationUtils.getValue((Annotation)annotation, (String)name);
            if (!requiredType.isInstance(value) || !MessagingAnnotationUtils.hasValue(value)) continue;
            return (T)value;
        }
        return null;
    }

    public static boolean hasValue(Object annotationValue) {
        if (annotationValue == null) {
            return false;
        }
        if (ObjectUtils.isArray((Object)annotationValue) && ObjectUtils.isEmpty((Object)annotationValue)) {
            return false;
        }
        if (annotationValue instanceof String && ObjectUtils.isEmpty((Object)annotationValue)) {
            return false;
        }
        return !(annotationValue instanceof Annotation) || !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(AnnotationUtils.getValue((Annotation)((Annotation)annotationValue)));
    }

    public static Method findAnnotatedMethod(Object target, Class<? extends Annotation> annotationType) {
        AtomicReference reference = new AtomicReference();
        ReflectionUtils.doWithMethods((Class)AopProxyUtils.ultimateTargetClass((Object)target), method -> reference.compareAndSet(null, method), method -> ReflectionUtils.USER_DECLARED_METHODS.matches(method) && AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)annotationType.getName()));
        return (Method)reference.get();
    }

    public static Annotation findMessagePartAnnotation(Annotation[] annotations, boolean payloads) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        Annotation match = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (!type.equals(Payload.class) && !type.equals(Header.class) && !type.equals(Headers.class) && (!payloads || !type.equals(Payloads.class))) continue;
            if (match != null) {
                throw new MessagingException("At most one parameter annotation can be provided for message mapping, but found two: [" + match.annotationType().getName() + "] and [" + annotation.annotationType().getName() + "]");
            }
            match = annotation;
        }
        return match;
    }

    @Nullable
    public static String endpointIdValue(Method method) {
        return MessagingAnnotationUtils.endpointIdValue(MergedAnnotations.from((AnnotatedElement)method));
    }

    @Nullable
    public static String endpointIdValue(MergedAnnotations mergedAnnotations) {
        MergedAnnotation endpointIdAnnotation = mergedAnnotations.get(EndpointId.class);
        return endpointIdAnnotation.getValue("value", String.class).orElse(null);
    }

    public static List<Annotation> getAnnotationChain(Annotation messagingAnnotation, Class<? extends Annotation> annotationType) {
        LinkedList<Annotation> annotationChain = new LinkedList<Annotation>();
        HashSet<Annotation> visited = new HashSet<Annotation>();
        MessagingAnnotationUtils.recursiveFindAnnotation(annotationType, messagingAnnotation, annotationChain, visited);
        if (annotationChain.size() > 0) {
            Collections.reverse(annotationChain);
        }
        return annotationChain;
    }

    private static boolean recursiveFindAnnotation(Class<? extends Annotation> annotationType, Annotation ann, List<Annotation> annotationChain, Set<Annotation> visited) {
        if (ann.annotationType().equals(annotationType)) {
            annotationChain.add(ann);
            return true;
        }
        for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
            if (ann.equals(metaAnn) || visited.contains(metaAnn) || metaAnn.annotationType().getPackage().getName().startsWith("java.lang")) continue;
            visited.add(metaAnn);
            if (!MessagingAnnotationUtils.recursiveFindAnnotation(annotationType, metaAnn, annotationChain, visited)) continue;
            annotationChain.add(ann);
            return true;
        }
        return false;
    }

    private MessagingAnnotationUtils() {
    }
}

