/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.ResolvableType;
import org.springframework.integration.annotation.Splitter;
import org.springframework.integration.config.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.SplitterFactoryBean;
import org.springframework.integration.splitter.MethodInvokingSplitter;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class SplitterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Splitter> {
    private static final String APPLY_SEQUENCE_ATTR = "applySequence";

    public SplitterAnnotationPostProcessor() {
        this.messageHandlerAttributes.addAll(Arrays.asList("outputChannel", APPLY_SEQUENCE_ATTR, "adviceChain"));
    }

    @Override
    protected BeanDefinition resolveHandlerBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, ResolvableType handlerBeanType, List<Annotation> annotations) {
        BeanDefinition handlerBeanDefinition = super.resolveHandlerBeanDefinition(beanName, beanDefinition, handlerBeanType, annotations);
        if (handlerBeanDefinition != null) {
            return handlerBeanDefinition;
        }
        BeanDefinition targetObjectBeanDefinition = SplitterAnnotationPostProcessor.buildLambdaMessageProcessor(handlerBeanType, beanDefinition);
        if (targetObjectBeanDefinition == null) {
            targetObjectBeanDefinition = new RuntimeBeanReference(beanName);
        }
        BeanDefinitionBuilder splitterBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(SplitterFactoryBean.class).addPropertyValue("targetObject", (Object)targetObjectBeanDefinition);
        String applySequence = MessagingAnnotationUtils.resolveAttribute(annotations, APPLY_SEQUENCE_ATTR, String.class);
        if (StringUtils.hasText((String)applySequence)) {
            splitterBeanDefinition.addPropertyValue(APPLY_SEQUENCE_ATTR, (Object)applySequence);
        }
        return splitterBeanDefinition.getBeanDefinition();
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        MethodInvokingSplitter splitter = new MethodInvokingSplitter(bean, method);
        String applySequence = MessagingAnnotationUtils.resolveAttribute(annotations, APPLY_SEQUENCE_ATTR, String.class);
        if (StringUtils.hasText((String)applySequence)) {
            splitter.setApplySequence(this.resolveAttributeToBoolean(applySequence));
        }
        SplitterAnnotationPostProcessor.setOutputChannelIfPresent(annotations, splitter);
        return splitter;
    }
}

