/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.config.SpelFunctionFactoryBean;

public final class IntegrationConfigUtils {
    public static final String HANDLER_ALIAS_SUFFIX = ".handler";

    public static void registerSpelFunctionBean(BeanDefinitionRegistry registry, String functionId, String className, String methodSignature) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SpelFunctionFactoryBean.class).addConstructorArgValue((Object)className).addConstructorArgValue((Object)methodSignature);
        registry.registerBeanDefinition(functionId, (BeanDefinition)builder.getBeanDefinition());
    }

    public static void registerSpelFunctionBean(BeanDefinitionRegistry registry, String functionId, Class<?> aClass, String methodSignature) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SpelFunctionFactoryBean.class).addConstructorArgValue(aClass).addConstructorArgValue((Object)methodSignature);
        registry.registerBeanDefinition(functionId, (BeanDefinition)builder.getBeanDefinition());
    }

    public static void autoCreateDirectChannel(String channelName, BeanDefinitionRegistry registry) {
        registry.registerBeanDefinition(channelName, (BeanDefinition)new RootBeanDefinition(DirectChannel.class));
    }

    public static BeanNameGenerator annotationBeanNameGenerator(BeanDefinitionRegistry registry) {
        SingletonBeanRegistry singletonBeanRegistry;
        BeanNameGenerator generator;
        AnnotationBeanNameGenerator beanNameGenerator = AnnotationBeanNameGenerator.INSTANCE;
        if (registry instanceof SingletonBeanRegistry && (generator = (BeanNameGenerator)(singletonBeanRegistry = (SingletonBeanRegistry)registry).getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator")) != null) {
            beanNameGenerator = generator;
        }
        return beanNameGenerator;
    }

    private IntegrationConfigUtils() {
    }
}

