/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.MessagingGateway;
import org.springframework.integration.config.IntegrationConfigUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class IntegrationComponentScanRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private static final Log LOGGER = LogFactory.getLog(IntegrationComponentScanRegistrar.class);
    private static final String BEAN_NAME = IntegrationComponentScanRegistrar.class.getName();
    private final List<TypeFilter> defaultFilters = new ArrayList<TypeFilter>();
    private ResourceLoader resourceLoader;
    private Environment environment;

    public IntegrationComponentScanRegistrar() {
        this.defaultFilters.add((TypeFilter)new AnnotationTypeFilter(MessagingGateway.class, true));
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes componentScan = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(IntegrationComponentScan.class.getName()));
        Assert.notNull((Object)componentScan, (String)"The '@IntegrationComponentScan' must be present for using this registrar");
        if (registry.containsBeanDefinition(BEAN_NAME)) {
            LOGGER.warn((Object)"Only one '@IntegrationComponentScan' can be present.\nConsider to merge them all to one.");
            return;
        }
        registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(IntegrationComponentScanRegistrar.class).setRole(2).getBeanDefinition());
        Collection<String> basePackages = this.getBasePackages(componentScan, registry);
        if (basePackages.isEmpty()) {
            basePackages = Collections.singleton(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry, false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation();
            }
        };
        this.filter(registry, componentScan, (ClassPathScanningCandidateComponentProvider)scanner);
        scanner.setResourceLoader(this.resourceLoader);
        scanner.setEnvironment(this.environment);
        BeanNameGenerator beanNameGenerator = IntegrationConfigUtils.annotationBeanNameGenerator(registry);
        Class generatorClass = componentScan.getClass("nameGenerator");
        if (BeanNameGenerator.class != generatorClass) {
            beanNameGenerator = (BeanNameGenerator)BeanUtils.instantiateClass((Class)generatorClass);
        }
        scanner.setBeanNameGenerator(beanNameGenerator);
        scanner.scan((String[])basePackages.toArray(String[]::new));
    }

    private void filter(BeanDefinitionRegistry registry, AnnotationAttributes componentScan, ClassPathScanningCandidateComponentProvider scanner) {
        if (componentScan.getBoolean("useDefaultFilters")) {
            for (TypeFilter typeFilter : this.defaultFilters) {
                scanner.addIncludeFilter(typeFilter);
            }
        }
        for (AnnotationAttributes filter2 : componentScan.getAnnotationArray("includeFilters")) {
            for (TypeFilter typeFilter : this.typeFiltersFor(filter2, registry)) {
                scanner.addIncludeFilter(typeFilter);
            }
        }
        for (AnnotationAttributes filter2 : componentScan.getAnnotationArray("excludeFilters")) {
            for (TypeFilter typeFilter : this.typeFiltersFor(filter2, registry)) {
                scanner.addExcludeFilter(typeFilter);
            }
        }
    }

    protected Collection<String> getBasePackages(AnnotationAttributes componentScan, BeanDefinitionRegistry registry) {
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : componentScan.getStringArray("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : componentScan.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        return basePackages;
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filter2, BeanDefinitionRegistry registry) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)filter2.getEnum("type");
        block9: for (Class filterClass : filter2.getClassArray("classes")) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)"An error occurred while processing a @IntegrationComponentScan ANNOTATION type filter: ");
                    Class annotationType = filterClass;
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(annotationType));
                    continue block9;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    continue block9;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)"An error occurred while processing a @IntegrationComponentScan CUSTOM type filter: ");
                    TypeFilter typeFilter = (TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class);
                    IntegrationComponentScanRegistrar.invokeAwareMethods(filter2, this.environment, this.resourceLoader, registry);
                    typeFilters.add(typeFilter);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Filter type not supported with Class value: " + filterType);
                }
            }
        }
        block10: for (String expression : filter2.getStringArray("pattern")) {
            switch (filterType) {
                case ASPECTJ: {
                    typeFilters.add((TypeFilter)new AspectJTypeFilter(expression, this.resourceLoader.getClassLoader()));
                    continue block10;
                }
                case REGEX: {
                    typeFilters.add((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(expression)));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Filter type not supported with String pattern: " + filterType);
                }
            }
        }
        return typeFilters;
    }

    private static void invokeAwareMethods(Object parserStrategyBean, Environment environment, ResourceLoader resourceLoader, BeanDefinitionRegistry registry) {
        if (parserStrategyBean instanceof Aware) {
            if (parserStrategyBean instanceof BeanClassLoaderAware) {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = registry instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)registry).getBeanClassLoader() : resourceLoader.getClassLoader();
                if (classLoader != null) {
                    ((BeanClassLoaderAware)parserStrategyBean).setBeanClassLoader(classLoader);
                }
            }
            if (parserStrategyBean instanceof BeanFactoryAware && registry instanceof BeanFactory) {
                ((BeanFactoryAware)parserStrategyBean).setBeanFactory((BeanFactory)registry);
            }
            if (parserStrategyBean instanceof EnvironmentAware) {
                ((EnvironmentAware)parserStrategyBean).setEnvironment(environment);
            }
            if (parserStrategyBean instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)parserStrategyBean).setResourceLoader(resourceLoader);
            }
        }
    }
}

