/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum ParamTypeEnum {
    PATH("path", true),
    FORM_DATA("form-data", true),
    POST("post", true),
    URI("uri", true),
    QUERY("query", true),
    HOST("host", true),
    IP("ip", true),
    HEADER("header", true),
    COOKIE("cookie", true),
    REQUEST_METHOD("req_method", true),
    DOMAIN("domain", true);

    private final String name;
    private final Boolean support;

    private ParamTypeEnum(String name, Boolean support) {
        this.name = name;
        this.support = support;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getSupport() {
        return this.support;
    }

    public static List<ParamTypeEnum> acquireSupport() {
        return Arrays.stream(ParamTypeEnum.values()).filter(e -> e.support).collect(Collectors.toList());
    }

    public static ParamTypeEnum getParamTypeEnumByName(String name) {
        return Arrays.stream(ParamTypeEnum.values()).filter(e -> e.getName().equals(name) && e.support != false).findFirst().orElse(null);
    }
}

