/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.web.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.IWebRequest;

public interface IServletWebRequest
extends IWebRequest {
    public String getContextPath();

    public String getRequestURI();

    @Override
    default public String getApplicationPath() {
        return this.getContextPath();
    }

    @Override
    default public String getPathWithinApplication() {
        String requestURI = this.getRequestURI();
        String applicationPath = this.getApplicationPath();
        if (requestURI == null) {
            return null;
        }
        if (applicationPath == null || applicationPath.length() == 0) {
            return requestURI;
        }
        return requestURI.substring(applicationPath.length());
    }

    public Enumeration<String> getHeaderNames();

    public Enumeration<String> getHeaders(String var1);

    @Override
    default public boolean containsHeader(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.getHeaderValue(name) != null;
    }

    @Override
    default public int getHeaderCount() {
        int count = 0;
        Enumeration<String> headerNamesEnum = this.getHeaderNames();
        while (headerNamesEnum.hasMoreElements()) {
            headerNamesEnum.nextElement();
            ++count;
        }
        return count;
    }

    @Override
    default public Set<String> getAllHeaderNames() {
        LinkedHashSet<String> headerNames = new LinkedHashSet<String>(10);
        Enumeration<String> headerNamesEnum = this.getHeaderNames();
        while (headerNamesEnum.hasMoreElements()) {
            headerNames.add(headerNamesEnum.nextElement());
        }
        return Collections.unmodifiableSet(headerNames);
    }

    @Override
    default public Map<String, String[]> getHeaderMap() {
        LinkedHashMap<String, String[]> headerMap = new LinkedHashMap<String, String[]>(10);
        Enumeration<String> headerNamesEnum = this.getHeaderNames();
        while (headerNamesEnum.hasMoreElements()) {
            String headerName = headerNamesEnum.nextElement();
            headerMap.put(headerName, this.getHeaderValues(headerName));
        }
        return Collections.unmodifiableMap(headerMap);
    }

    @Override
    default public String[] getHeaderValues(String name) {
        Validate.notNull(name, "Name cannot be null");
        Enumeration<String> headerValues = this.getHeaders(name);
        if (headerValues == null || !headerValues.hasMoreElements()) {
            return null;
        }
        ArrayList<String> headerValueList = Collections.list(headerValues);
        return headerValueList.toArray(new String[headerValueList.size()]);
    }

    @Override
    default public boolean containsParameter(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.getParameterValues(name) != null;
    }

    @Override
    default public int getParameterCount() {
        return this.getParameterMap().size();
    }

    @Override
    default public Set<String> getAllParameterNames() {
        return this.getParameterMap().keySet();
    }

    public Object getNativeRequestObject();
}

