/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.infra.etcd.autoconfig;

import io.etcd.jetcd.Client;
import org.apache.shenyu.infra.etcd.autoconfig.ConditionOnSyncEtcd;
import org.apache.shenyu.infra.etcd.autoconfig.EtcdProperties;
import org.apache.shenyu.infra.etcd.client.EtcdClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionOnSyncEtcd
@ConditionalOnClass(value={Client.class})
@EnableConfigurationProperties(value={EtcdProperties.class})
public class EtcdConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EtcdConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public EtcdClient etcdClient(EtcdProperties etcdProperties) {
        log.info("Initializing Etcd Client with URL: {}", (Object)etcdProperties.getEtcd().getUrl());
        return EtcdClient.builder().client(Client.builder().endpoints(etcdProperties.getEtcd().getUrl().split(",")).build()).build();
    }
}

