/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.tree.JsonTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.processors.data.FullData;

public final class SchemaContext
implements MessageProvider {
    private final SchemaTree schema;
    private final NodeType instanceType;

    public SchemaContext(FullData data) {
        this.schema = data.getSchema();
        JsonTree tree = data.getInstance();
        this.instanceType = tree != null ? NodeType.getNodeType((JsonNode)tree.getNode()) : null;
    }

    public SchemaContext(SchemaTree schema, NodeType instanceType) {
        this.schema = schema;
        this.instanceType = instanceType;
    }

    public SchemaTree getSchema() {
        return this.schema;
    }

    public NodeType getInstanceType() {
        return this.instanceType;
    }

    public ProcessingMessage newMessage() {
        return new ProcessingMessage().put("schema", (AsJson)this.schema);
    }
}

