/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.examples.Utils;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public final class Example7 {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode good = Utils.loadResource("/fstab-good.json");
        JsonNode bad = Utils.loadResource("/fstab-bad.json");
        JsonNode bad2 = Utils.loadResource("/fstab-bad2.json");
        LoadingConfiguration cfg = LoadingConfiguration.newBuilder().addScheme("foobar", CustomDownloader.getInstance()).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema("foobar:/fstab.json#");
        ProcessingReport report = schema.validate(good);
        System.out.println(report);
        report = schema.validate(bad);
        System.out.println(report);
        report = schema.validate(bad2);
        System.out.println(report);
    }

    private static final class CustomDownloader
    implements URIDownloader {
        private static final String PREFIX;
        private static final URIDownloader INSTANCE;

        private CustomDownloader() {
        }

        public static URIDownloader getInstance() {
            return INSTANCE;
        }

        public InputStream fetch(URI source) throws IOException {
            String path = PREFIX + source.getPath();
            InputStream ret = this.getClass().getResourceAsStream(path);
            if (ret == null) {
                throw new IOException("resource " + path + " not found");
            }
            return ret;
        }

        static {
            INSTANCE = new CustomDownloader();
            String pkgname = CustomDownloader.class.getPackage().getName();
            PREFIX = '/' + pkgname.replace(".", "/");
        }
    }
}

