/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.netflix.servo.tag.SmallTagMap;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import com.netflix.servo.util.Iterables;
import com.netflix.servo.util.Preconditions;
import com.netflix.servo.util.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class BasicTagList
implements TagList {
    public static final TagList EMPTY = new BasicTagList(Collections.emptySet());
    private final SmallTagMap tagMap;
    private SortedMap<String, String> sortedTaglist;

    public BasicTagList(SmallTagMap tagMap) {
        this.tagMap = tagMap;
    }

    public BasicTagList(Iterable<Tag> entries) {
        SmallTagMap.Builder builder = SmallTagMap.builder();
        builder.addAll(entries);
        this.tagMap = builder.result();
    }

    @Override
    public Tag getTag(String key) {
        return this.tagMap.get(key);
    }

    @Override
    public String getValue(String key) {
        Tag t = this.tagMap.get(key);
        return t == null ? null : t.getValue();
    }

    @Override
    public boolean containsKey(String key) {
        return this.tagMap.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.tagMap.isEmpty();
    }

    @Override
    public int size() {
        return this.tagMap.size();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tagMap.iterator();
    }

    @Override
    public Map<String, String> asMap() {
        if (this.sortedTaglist != null) {
            return this.sortedTaglist;
        }
        TreeMap<String, String> tagMap = new TreeMap<String, String>();
        for (Tag tag : this.tagMap) {
            tagMap.put(tag.getKey(), tag.getValue());
        }
        this.sortedTaglist = Collections.unmodifiableSortedMap(tagMap);
        return this.sortedTaglist;
    }

    public BasicTagList copy(TagList tags) {
        return BasicTagList.concat((TagList)this, tags);
    }

    public BasicTagList copy(String key, String value) {
        return BasicTagList.concat((TagList)this, Tags.newTag(key, value));
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof BasicTagList && this.tagMap.equals(((BasicTagList)obj).tagMap);
    }

    public int hashCode() {
        return this.tagMap.hashCode();
    }

    public String toString() {
        return Strings.join(",", this.tagMap.iterator());
    }

    public static BasicTagList concat(TagList t1, TagList t2) {
        return new BasicTagList(Iterables.concat(t1, t2));
    }

    public static BasicTagList concat(TagList t1, Tag ... t2) {
        return new BasicTagList(Iterables.concat(t1, Arrays.asList(t2)));
    }

    public static BasicTagList of(String ... tags) {
        Preconditions.checkArgument(tags.length % 2 == 0, "tags must be a sequence of key,value pairs");
        SmallTagMap.Builder builder = SmallTagMap.builder();
        for (int i = 0; i < tags.length; i += 2) {
            Tag t = Tags.newTag(tags[i], tags[i + 1]);
            builder.add(t);
        }
        return new BasicTagList(builder.result());
    }

    public static BasicTagList of(Tag ... tags) {
        return new BasicTagList(Arrays.asList(tags));
    }

    @Deprecated
    public static BasicTagList copyOf(Tag ... tags) {
        return new BasicTagList(Arrays.asList(tags));
    }

    @Deprecated
    public static BasicTagList copyOf(String ... tags) {
        return BasicTagList.copyOf(Arrays.asList(tags));
    }

    public static BasicTagList copyOf(Iterable<String> tags) {
        SmallTagMap.Builder builder = SmallTagMap.builder();
        for (String tag : tags) {
            builder.add(Tags.parseTag(tag));
        }
        return new BasicTagList(builder.result());
    }

    public static BasicTagList copyOf(Map<String, String> tags) {
        SmallTagMap.Builder builder = SmallTagMap.builder();
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            builder.add(Tags.newTag(tag.getKey(), tag.getValue()));
        }
        return new BasicTagList(builder.result());
    }
}

