/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css.codegen;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSFontFace;
import org.apache.royale.compiler.css.ICSSMediaQueryCondition;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.css.ICSSSelector;
import org.apache.royale.compiler.internal.css.CSSDocument;
import org.apache.royale.compiler.internal.css.CSSFontFace;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSMediaQueryCondition;
import org.apache.royale.compiler.internal.css.CSSNamespaceDefinition;
import org.apache.royale.compiler.internal.css.CSSProperty;
import org.apache.royale.compiler.internal.css.CSSRule;
import org.apache.royale.compiler.internal.css.CSSSelector;
import org.apache.royale.compiler.internal.css.codegen.CSSEmitter;
import org.apache.royale.compiler.internal.css.codegen.CSSReducer;
import org.apache.royale.compiler.internal.css.codegen.ICSSCodeGenResult;
import org.apache.royale.compiler.internal.css.semantics.CSSSemanticAnalyzer;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.projects.IRoyaleProject;

public class CSSCompilationSession {
    private static final CommonTree NO_TREE = null;
    private static final TokenStream NO_TOKEN_STREAM = null;
    private static final ImmutableList<CSSMediaQueryCondition> NO_MEDIA_QUERIES = ImmutableList.of();
    public final Map<CSSFunctionCallPropertyValue, EmbedCompilationUnit> resolvedEmbedProperties;
    public final Map<ICSSSelector, String> resolvedSelectors = new LinkedHashMap<ICSSSelector, String>();
    public final Set<String> inheritingStyles = new LinkedHashSet<String>();
    public final Set<ICSSRule> activatedRules;
    public ArrayList<CSSFontFace> fontFaces;
    public final List<ICSSDocument> cssDocuments;
    private final Map<String, SingleSelectorRule> singleSelectorRules;
    private final Set<ICSSRule> rulesWithMediaQueries;
    private boolean cssDisabled = false;
    private boolean keepAllTypeSelectors = false;
    private static Function<ICSSProperty, CSSProperty> INTERF_TO_IMPL = new Function<ICSSProperty, CSSProperty>(){

        public CSSProperty apply(ICSSProperty property) {
            return (CSSProperty)property;
        }
    };

    public CSSCompilationSession() {
        this.resolvedEmbedProperties = new HashMap<CSSFunctionCallPropertyValue, EmbedCompilationUnit>();
        this.activatedRules = new HashSet<ICSSRule>();
        this.cssDocuments = new ArrayList<ICSSDocument>();
        this.fontFaces = new ArrayList();
        this.singleSelectorRules = new LinkedHashMap<String, SingleSelectorRule>();
        this.rulesWithMediaQueries = new LinkedHashSet<ICSSRule>();
    }

    protected boolean keepRule(ICSSRule newRule) {
        return this.keepAllTypeSelectors || this.activatedRules.contains(newRule);
    }

    protected ICSSDocument synthesisNormalizedCSS(boolean isSWF) {
        this.fontFaces = new ArrayList();
        for (ICSSDocument cssDocument : this.cssDocuments) {
            for (ICSSRule newRule : cssDocument.getRules()) {
                if (!this.keepRule(newRule)) continue;
                this.addRuleToCodeGeneration(newRule, isSWF);
            }
            for (ICSSFontFace fontFace : cssDocument.getFontFaces()) {
                this.fontFaces.add((CSSFontFace)fontFace);
            }
        }
        ArrayList<CSSRule> rules = new ArrayList<CSSRule>();
        for (SingleSelectorRule ssRule : this.singleSelectorRules.values()) {
            rules.add(ssRule.createCSSRule());
        }
        for (ICSSRule rule : this.rulesWithMediaQueries) {
            rules.add((CSSRule)rule);
        }
        return new SynthesizedCSSDocument(rules, this.fontFaces);
    }

    private void addRuleToCodeGeneration(ICSSRule newRule, boolean isSWF) {
        ImmutableList<ICSSMediaQueryCondition> mq = newRule.getMediaQueryConditions();
        if (mq.isEmpty() || isSWF && mq.size() == 1 && ((ICSSMediaQueryCondition)mq.get(0)).getValue().toString().equals("-royale-swf")) {
            ImmutableList properties = ImmutableList.copyOf((Collection)Collections2.transform(newRule.getProperties(), INTERF_TO_IMPL));
            for (ICSSSelector newSelector : newRule.getSelectorGroup()) {
                String selectorName = this.getResolvedSelectorName(newSelector);
                assert (selectorName != null) : "All selectors in the rule must be resolved before the rule can be activated.";
                SingleSelectorRule activatedRuleWithSameSelector = this.singleSelectorRules.get(selectorName);
                if (activatedRuleWithSameSelector == null) {
                    SingleSelectorRule newSingleSelectorRule = new SingleSelectorRule((CSSSelector)newSelector, (List<CSSProperty>)properties);
                    this.singleSelectorRules.put(selectorName, newSingleSelectorRule);
                    continue;
                }
                for (CSSProperty newProperty : properties) {
                    String propertyName = newProperty.getName();
                    activatedRuleWithSameSelector.propertyMap.put(propertyName, newProperty);
                }
            }
        } else {
            this.rulesWithMediaQueries.add(newRule);
        }
    }

    public ICSSCodeGenResult emitStyleDataClass(IRoyaleProject project, IABCVisitor abcVisitor) throws Exception {
        ICSSDocument css = this.synthesisNormalizedCSS(true);
        CSSReducer reducer = new CSSReducer(project, css, abcVisitor, this, true, 0);
        CSSEmitter emitter = new CSSEmitter(reducer);
        emitter.burm(css);
        return reducer;
    }

    private String getResolvedSelectorName(ICSSSelector selector) {
        String qname;
        String selectorQname = CSSSemanticAnalyzer.isWildcardSelector(selector) ? "" : ((qname = this.resolvedSelectors.get(selector)) == null ? selector.getElementName() : qname);
        String resolvedSelectorName = selectorQname.concat(selector.getCSSSyntaxNoNamespaces());
        return resolvedSelectorName;
    }

    public void disable() {
        this.cssDisabled = true;
    }

    public boolean isDisabled() {
        return this.cssDisabled;
    }

    public boolean isKeepAllTypeSelectors() {
        return this.keepAllTypeSelectors;
    }

    public void setKeepAllTypeSelectors(boolean keepAllTypeSelectors) {
        this.keepAllTypeSelectors = keepAllTypeSelectors;
    }

    private static class SingleSelectorRule {
        private final CSSSelector selector;
        private final Map<String, CSSProperty> propertyMap = new HashMap<String, CSSProperty>();

        private SingleSelectorRule(CSSSelector selector, List<CSSProperty> properties) {
            for (CSSProperty property : properties) {
                this.propertyMap.put(property.getName(), property);
            }
            this.selector = selector;
        }

        private CSSRule createCSSRule() {
            CSSRule cssRule = new CSSRule((List<CSSMediaQueryCondition>)NO_MEDIA_QUERIES, (List<CSSSelector>)ImmutableList.of((Object)this.selector), (List<CSSProperty>)ImmutableList.copyOf(this.propertyMap.values()), NO_TREE, NO_TOKEN_STREAM);
            return cssRule;
        }
    }

    private static class SynthesizedCSSDocument
    extends CSSDocument {
        private static final List<CSSNamespaceDefinition> NO_NAMESPACES = ImmutableList.of();

        private SynthesizedCSSDocument(List<CSSRule> rules, List<CSSFontFace> fontFaces) {
            super(rules, NO_NAMESPACES, fontFaces, NO_TREE, NO_TOKEN_STREAM);
        }
    }
}

