/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.instructionlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.InstructionFactory;
import org.apache.royale.abc.semantics.Label;

public class InstructionList
implements Cloneable {
    private static final int NO_EXECUTABLE_INSTRUCTIONS = -1;
    private ArrayList<Instruction> leafInstructions = null;
    private Instruction insn1 = null;
    private Instruction insn2 = null;
    private Instruction insn3 = null;
    private ArrayList<Label> activeLabels = null;
    private ArrayList<Label> pendingLabels = null;
    private boolean isValid = true;

    public InstructionList() {
    }

    public InstructionList(int capacity) {
        this();
        this.leafInstructions = new ArrayList(capacity);
    }

    private void copyInstructionList(InstructionList src) {
        src.checkValidity();
        ArrayList<Label> remainingActiveLabels = null;
        if (src.activeLabels != null) {
            this.activeLabels = new ArrayList(src.activeLabels.size());
            remainingActiveLabels = new ArrayList<Label>(src.activeLabels);
        }
        ArrayList<Label> remainingPendingLabels = null;
        if (src.pendingLabels != null) {
            this.pendingLabels = new ArrayList(src.pendingLabels.size());
            remainingPendingLabels = new ArrayList<Label>(src.pendingLabels);
        }
        if (!src.isEmpty()) {
            this.insn1 = this.updateInstructionLabel(src.insn1, remainingActiveLabels, (Collection<Label>)remainingPendingLabels);
            this.insn2 = this.updateInstructionLabel(src.insn2, remainingActiveLabels, remainingPendingLabels);
            this.insn3 = this.updateInstructionLabel(src.insn3, remainingActiveLabels, remainingPendingLabels);
            if (src.leafInstructions != null) {
                this.leafInstructions = new ArrayList(src.leafInstructions.size());
                for (int i = 0; i < src.leafInstructions.size(); ++i) {
                    this.leafInstructions.add(this.updateInstructionLabel(src.leafInstructions.get(i), remainingActiveLabels, remainingPendingLabels));
                }
            }
        }
        if (remainingActiveLabels != null) {
            for (Label label : remainingActiveLabels) {
                this.activeLabels.add((Label)label.clone());
            }
        }
        if (remainingPendingLabels != null) {
            for (Label label : remainingPendingLabels) {
                this.pendingLabels.add((Label)label.clone());
            }
        }
    }

    public Instruction firstElement() {
        this.checkValidity();
        switch (this.getStorageState()) {
            case Variable: {
                return this.leafInstructions.get(0);
            }
            case Ins1: 
            case Ins2: 
            case Ins3: {
                return this.insn1;
            }
        }
        throw new NoSuchElementException();
    }

    public Instruction lastElement() {
        this.checkValidity();
        switch (this.getStorageState()) {
            case Variable: {
                return this.leafInstructions.get(this.leafInstructions.size() - 1);
            }
            case Ins3: {
                return this.insn3;
            }
            case Ins2: {
                return this.insn2;
            }
            case Ins1: {
                return this.insn1;
            }
        }
        throw new NoSuchElementException();
    }

    public boolean isEmpty() {
        this.checkValidity();
        return this.size() == 0;
    }

    public ArrayList<Instruction> getInstructions() {
        this.checkValidity();
        switch (this.getStorageState()) {
            case Ins3: {
                this.leafInstructions = new ArrayList();
                this.leafInstructions.add(this.insn1);
                this.insn1 = null;
                this.leafInstructions.add(this.insn2);
                this.insn2 = null;
                this.leafInstructions.add(this.insn3);
                this.insn3 = null;
                break;
            }
            case Ins2: {
                this.leafInstructions = new ArrayList();
                this.leafInstructions.add(this.insn1);
                this.insn1 = null;
                this.leafInstructions.add(this.insn2);
                this.insn2 = null;
                break;
            }
            case Ins1: {
                this.leafInstructions = new ArrayList();
                this.leafInstructions.add(this.insn1);
                this.insn1 = null;
                break;
            }
            case Empty: {
                this.leafInstructions = new ArrayList();
                break;
            }
            case Variable: {
                break;
            }
            default: {
                assert (false) : "Unknown storage state " + this.getStorageState();
                break;
            }
        }
        return this.leafInstructions;
    }

    public Label getLabel() {
        this.checkValidity();
        Label result = new Label();
        this.labelFirst(result);
        return result;
    }

    public Instruction addInstruction(Instruction insn) {
        this.checkValidity();
        if (insn.isExecutable()) {
            this.resolvePendingLabels();
        }
        switch (this.getStorageState()) {
            case Variable: 
            case Ins3: {
                this.getInstructions().add(insn);
                break;
            }
            case Empty: {
                this.insn1 = insn;
                break;
            }
            case Ins1: {
                this.insn2 = insn;
                break;
            }
            case Ins2: {
                this.insn3 = insn;
                break;
            }
            default: {
                assert (false) : "Unknown storage state " + this.getStorageState();
                break;
            }
        }
        return insn;
    }

    public Instruction addInstruction(int opcode) {
        return this.addInstruction(InstructionFactory.getInstruction(opcode));
    }

    public Instruction addInstruction(int opcode, int immed) {
        return this.addInstruction(InstructionFactory.getInstruction(opcode, immed));
    }

    public Instruction addInstruction(int opcode, Object[] operands) {
        return this.addInstruction(InstructionFactory.getInstruction(opcode, operands));
    }

    public Instruction addInstruction(int opcode, Object operand) {
        return this.addInstruction(InstructionFactory.getInstruction(opcode, operand));
    }

    public void addAll(InstructionList src_list) {
        this.checkValidity();
        src_list.checkValidity();
        if (src_list.activeLabels != null) {
            if (!this.isEmpty()) {
                for (Label l : src_list.activeLabels) {
                    l.adjustOffset(this.size());
                }
            }
            this.getActiveLabels().addAll(src_list.activeLabels);
        }
        if (!src_list.isEmpty()) {
            int firstExecutableOffset = src_list.firstExecutableOffset();
            if (firstExecutableOffset != -1) {
                this.resolvePendingLabels(this.size() + firstExecutableOffset);
            }
            StorageState this_state = this.getStorageState();
            StorageState src_state = src_list.getStorageState();
            block0 : switch (this_state) {
                case Empty: {
                    switch (src_state) {
                        case Empty: {
                            break block0;
                        }
                        case Ins1: 
                        case Ins2: 
                        case Ins3: {
                            this.insn1 = src_list.insn1;
                            this.insn2 = src_list.insn2;
                            this.insn3 = src_list.insn3;
                            break block0;
                        }
                        case Variable: {
                            this.leafInstructions = src_list.leafInstructions;
                            break block0;
                        }
                    }
                    assert (false) : "Unknown storage state " + src_state;
                    break;
                }
                case Ins1: {
                    switch (src_state) {
                        case Empty: {
                            break block0;
                        }
                        case Ins1: 
                        case Ins2: {
                            this.insn2 = src_list.insn1;
                            this.insn3 = src_list.insn2;
                            break block0;
                        }
                        case Ins3: {
                            this.getInstructions().add(src_list.insn1);
                            this.getInstructions().add(src_list.insn2);
                            this.getInstructions().add(src_list.insn3);
                            break block0;
                        }
                        case Variable: {
                            this.getInstructions().addAll(src_list.getInstructions());
                            break block0;
                        }
                    }
                    assert (false) : "Unknown storage state " + src_state;
                    break;
                }
                case Ins2: {
                    switch (src_state) {
                        case Empty: {
                            break block0;
                        }
                        case Ins1: {
                            this.insn3 = src_list.insn1;
                            break block0;
                        }
                        case Ins2: {
                            this.getInstructions().add(src_list.insn1);
                            this.getInstructions().add(src_list.insn2);
                            break block0;
                        }
                        case Ins3: {
                            this.getInstructions().add(src_list.insn1);
                            this.getInstructions().add(src_list.insn2);
                            this.getInstructions().add(src_list.insn3);
                            break block0;
                        }
                        case Variable: {
                            this.getInstructions().addAll(src_list.getInstructions());
                            break block0;
                        }
                    }
                    assert (false) : "Unknown storage state " + src_state;
                    break;
                }
                case Ins3: {
                    switch (src_state) {
                        case Empty: {
                            break block0;
                        }
                        case Ins1: {
                            this.getInstructions().add(src_list.insn1);
                            break block0;
                        }
                        case Ins2: {
                            this.getInstructions().add(src_list.insn1);
                            this.getInstructions().add(src_list.insn2);
                            break block0;
                        }
                        case Ins3: {
                            this.getInstructions().add(src_list.insn1);
                            this.getInstructions().add(src_list.insn2);
                            this.getInstructions().add(src_list.insn3);
                            break block0;
                        }
                        case Variable: {
                            this.getInstructions().addAll(src_list.getInstructions());
                            break block0;
                        }
                    }
                    assert (false) : "Unknown storage state " + src_state;
                    break;
                }
                case Variable: {
                    switch (src_state) {
                        case Empty: {
                            break block0;
                        }
                        case Ins1: {
                            this.leafInstructions.add(src_list.insn1);
                            break block0;
                        }
                        case Ins2: {
                            this.leafInstructions.add(src_list.insn1);
                            this.leafInstructions.add(src_list.insn2);
                            break block0;
                        }
                        case Ins3: {
                            this.leafInstructions.add(src_list.insn1);
                            this.leafInstructions.add(src_list.insn2);
                            this.leafInstructions.add(src_list.insn3);
                            break block0;
                        }
                        case Variable: {
                            this.leafInstructions.addAll(src_list.getInstructions());
                            break block0;
                        }
                    }
                    assert (false) : "Unknown storage state " + src_state;
                    break;
                }
                default: {
                    assert (false) : "Unknown storage state " + this_state;
                    break;
                }
            }
        }
        if (src_list.pendingLabels != null) {
            if (this.pendingLabels == null) {
                this.pendingLabels = new ArrayList();
            }
            this.pendingLabels.addAll(src_list.pendingLabels);
        }
        src_list.isValid = false;
    }

    public void labelFirst(Label l) {
        if (this.firstExecutableOffset() != -1) {
            this.addLabelAt(l, this.firstExecutableOffset());
        } else {
            this.labelNext(l);
        }
    }

    public void labelCurrent(Label l) {
        if (l.targetMustBeExecutable() && this.lastExecutableOffset() != -1) {
            this.addLabelAt(l, this.lastExecutableOffset());
        } else if (!l.targetMustBeExecutable() && this.size() > 0) {
            this.addLabelAt(l, this.size() - 1);
        } else {
            this.labelNext(l);
        }
    }

    public void addLabelAt(Label l, int pos) {
        this.checkValidity();
        if (!this.isEmpty()) {
            assert (pos < this.size());
            if (l.getPosition() == -1) {
                l.setPosition(pos);
            } else assert (l.getPosition() == pos) : "Label position " + l.getPosition() + " != " + pos;
            this.addLabel(l);
        } else {
            assert (pos == 0);
            this.labelNext(l);
        }
    }

    private void addLabel(Label l) {
        this.getActiveLabels().add(l);
    }

    public ArrayList<Label> getActiveLabels() {
        this.checkValidity();
        if (null == this.activeLabels) {
            this.activeLabels = new ArrayList();
        }
        return this.activeLabels;
    }

    public Label getLastLabel() {
        this.checkValidity();
        Label result = new Label();
        this.labelCurrent(result);
        return result;
    }

    public void labelNext(Label l) {
        this.checkValidity();
        if (null == this.pendingLabels) {
            this.pendingLabels = new ArrayList();
        }
        this.pendingLabels.add(l);
    }

    private void resolvePendingLabels() {
        this.resolvePendingLabels(this.size());
    }

    private void resolvePendingLabels(int offset) {
        if (this.pendingLabels != null) {
            for (Label l : this.pendingLabels) {
                l.setPosition(offset);
            }
            this.getActiveLabels().addAll(this.pendingLabels);
            this.pendingLabels = null;
        }
    }

    private int firstExecutableOffset() {
        switch (this.getStorageState()) {
            case Variable: {
                int size = this.leafInstructions.size();
                for (int offset = 0; offset < size; ++offset) {
                    if (!this.leafInstructions.get(offset).isExecutable()) continue;
                    return offset;
                }
                break;
            }
            case Ins3: {
                if (this.insn1.isExecutable()) {
                    return 0;
                }
                if (this.insn2.isExecutable()) {
                    return 1;
                }
                if (!this.insn3.isExecutable()) break;
                return 2;
            }
            case Ins2: {
                if (this.insn1.isExecutable()) {
                    return 0;
                }
                if (!this.insn2.isExecutable()) break;
                return 1;
            }
            case Ins1: {
                if (!this.insn1.isExecutable()) break;
                return 0;
            }
            default: {
                assert (false) : "Unknown storage state " + this.getStorageState();
                break;
            }
            case Empty: 
        }
        return -1;
    }

    private int lastExecutableOffset() {
        switch (this.getStorageState()) {
            case Variable: {
                for (int offset = this.size() - 1; offset >= 0; --offset) {
                    if (!this.leafInstructions.get(offset).isExecutable()) continue;
                    return offset;
                }
                break;
            }
            case Ins3: {
                if (this.insn3.isExecutable()) {
                    return 2;
                }
                if (this.insn2.isExecutable()) {
                    return 1;
                }
                if (!this.insn1.isExecutable()) break;
                return 0;
            }
            case Ins2: {
                if (this.insn2.isExecutable()) {
                    return 1;
                }
                if (!this.insn1.isExecutable()) break;
                return 0;
            }
            case Ins1: {
                if (!this.insn1.isExecutable()) break;
                return 0;
            }
            default: {
                assert (false) : "Unknown storage state " + this.getStorageState();
                break;
            }
            case Empty: 
        }
        return -1;
    }

    public int size() {
        switch (this.getStorageState()) {
            case Variable: {
                return this.leafInstructions.size();
            }
            case Ins3: {
                return 3;
            }
            case Ins2: {
                return 2;
            }
            case Ins1: {
                return 1;
            }
            default: {
                assert (false) : "Unknown storage state " + this.getStorageState();
                break;
            }
            case Empty: 
        }
        return 0;
    }

    private StorageState getStorageState() {
        if (this.leafInstructions != null) {
            return StorageState.Variable;
        }
        if (this.insn3 != null) {
            assert (this.insn1 != null && this.insn2 != null);
            return StorageState.Ins3;
        }
        if (this.insn2 != null) {
            assert (this.insn1 != null);
            return StorageState.Ins2;
        }
        if (this.insn1 != null) {
            return StorageState.Ins1;
        }
        return StorageState.Empty;
    }

    public boolean hasPendingLabels() {
        this.checkValidity();
        return this.pendingLabels != null && !this.pendingLabels.isEmpty();
    }

    public Collection<Label> stripPendingLabels() {
        this.checkValidity();
        ArrayList<Label> pending_labels = this.pendingLabels;
        this.pendingLabels = null;
        return pending_labels;
    }

    public void addAllPendingLabels(Collection<Label> prev_pending) {
        this.checkValidity();
        if (prev_pending != null) {
            if (null == this.pendingLabels) {
                this.pendingLabels = new ArrayList();
            }
            this.pendingLabels.addAll(prev_pending);
        }
    }

    public boolean canFallThrough() {
        this.checkValidity();
        boolean can_fall_through = true;
        if (this.size() > 0) {
            int last_opcode = this.lastElement().getOpcode();
            can_fall_through = 71 != last_opcode && 72 != last_opcode && 16 != last_opcode && 3 != last_opcode;
        }
        return can_fall_through;
    }

    private void checkValidity() {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid InstructionList");
        }
    }

    private Instruction updateInstructionLabel(Instruction src, Collection<Label> srcActiveLabels, Collection<Label> srcPendingLabels) {
        if (src == null) {
            return null;
        }
        if (!src.isTargetableInstruction()) {
            return src;
        }
        int operandCount = src.getOperandCount();
        if (operandCount == 0) {
            return src;
        }
        Object[] newOperands = new Object[operandCount];
        for (int i = 0; i < operandCount; ++i) {
            Object operand = src.getOperand(i);
            if (!(operand instanceof Label)) {
                newOperands[i] = operand;
                continue;
            }
            Label srcLabel = (Label)operand;
            Label clonedLabel = (Label)srcLabel.clone();
            newOperands[i] = clonedLabel;
            if (srcActiveLabels != null && srcActiveLabels.remove(srcLabel)) {
                this.activeLabels.add(clonedLabel);
                continue;
            }
            if (srcPendingLabels == null || !srcPendingLabels.remove(srcLabel)) continue;
            this.pendingLabels.add(clonedLabel);
        }
        if (operandCount == 1) {
            return InstructionFactory.getInstruction(src.getOpcode(), newOperands[0]);
        }
        return InstructionFactory.getInstruction(src.getOpcode(), newOperands);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.insn1 != null) {
            result.append(this.insn1.toString());
            result.append('\n');
        }
        if (this.insn2 != null) {
            result.append(this.insn2.toString());
            result.append('\n');
        }
        if (this.insn3 != null) {
            result.append(this.insn3.toString());
            result.append('\n');
        }
        if (this.leafInstructions != null) {
            for (Instruction insn : this.leafInstructions) {
                result.append(insn.toString());
                result.append('\n');
            }
        }
        return result.toString();
    }

    public Object clone() {
        InstructionList newb;
        block3: {
            newb = null;
            try {
                newb = (InstructionList)super.clone();
            }
            catch (Exception cantHappen) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)cantHappen);
            }
        }
        if (newb != null) {
            newb.copyInstructionList(this);
        }
        return newb;
    }

    public boolean hasSuchInstruction(int opcode) {
        return this.findOccurrences(opcode, true) > 0;
    }

    public int countOccurrences(int opcode) {
        return this.findOccurrences(opcode, false);
    }

    public int findOccurrences(int opcode, boolean stop_after_first) {
        int result = 0;
        block0 : switch (this.getStorageState()) {
            case Empty: {
                break;
            }
            case Ins3: {
                if (this.insn3.getOpcode() == opcode) {
                    ++result;
                }
            }
            case Ins2: {
                if (this.insn2.getOpcode() == opcode) {
                    ++result;
                }
            }
            case Ins1: {
                if (this.insn1.getOpcode() != opcode) break;
                ++result;
                break;
            }
            case Variable: {
                for (Instruction insn : this.leafInstructions) {
                    if (insn.getOpcode() != opcode) continue;
                    ++result;
                    if (!stop_after_first) continue;
                    break block0;
                }
                break;
            }
        }
        return result;
    }

    public void pushNumericConstant(long value) {
        if (value >= -128L && value < 128L) {
            this.addInstruction(36, (int)value);
        } else if (value > 0L && value < 32768L) {
            this.addInstruction(37, (int)value);
        } else if (value > 1L && value < -2L) {
            this.addInstruction(45, (Object)((int)value));
        } else {
            this.addInstruction(47, value);
        }
    }

    private static enum StorageState {
        Variable,
        Ins2,
        Ins1,
        Empty,
        Ins3;

    }

    public static interface IFilter {
        public InstructionList filter(InstructionList var1);
    }
}

