/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf.types;

import org.apache.royale.swf.io.SWFWriter;
import org.apache.royale.swf.types.EdgeRecord;
import org.apache.royale.swf.types.ShapeRecord;

public class StraightEdgeRecord
extends EdgeRecord {
    private int deltaX = 0;
    private int deltaY = 0;

    public StraightEdgeRecord() {
        super(ShapeRecord.ShapeRecordType.STRAIGHT_EDGE);
    }

    public StraightEdgeRecord(int deltaX, int deltaY) {
        this();
        this.setDelta(deltaX, deltaY);
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void setDelta(int deltaX, int deltaY) {
        this.deltaX = deltaX;
        this.deltaY = deltaY;
    }

    public int getNumBits() {
        int nBits = SWFWriter.requireSBCount(SWFWriter.maxNum(this.deltaX, this.deltaY, 0, 0));
        return nBits < 2 ? 0 : nBits - 2;
    }

    public LineType getLineType() {
        if (this.deltaX == 0) {
            return LineType.VERTICAL;
        }
        if (this.deltaY == 0) {
            return LineType.HORIZONTAL;
        }
        return LineType.GENERAL;
    }

    public static enum LineType {
        GENERAL,
        HORIZONTAL,
        VERTICAL;

    }
}

