/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v2;

import com.alibaba.fastjson2.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.config.v2.ConfigHelper;
import org.apache.rocketmq.broker.config.v2.ConfigStorage;
import org.apache.rocketmq.broker.config.v2.RecordPrefix;
import org.apache.rocketmq.broker.config.v2.SerializationType;
import org.apache.rocketmq.broker.config.v2.TableId;
import org.apache.rocketmq.broker.config.v2.TablePrefix;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class SubscriptionGroupManagerV2
extends SubscriptionGroupManager {
    private final ConfigStorage configStorage;

    public SubscriptionGroupManagerV2(BrokerController brokerController, ConfigStorage configStorage) {
        super(brokerController);
        this.configStorage = configStorage;
    }

    public boolean load() {
        return this.loadDataVersion() && this.loadSubscriptions();
    }

    @Override
    public boolean loadDataVersion() {
        try {
            ConfigHelper.loadDataVersion(this.configStorage, TableId.SUBSCRIPTION_GROUP).ifPresent(buf -> ConfigHelper.onDataVersionLoad(buf, this.dataVersion));
        }
        catch (RocksDBException e) {
            log.error("loadDataVersion error", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSubscriptions() {
        int keyLen = 4;
        ByteBuf beginKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        beginKey.writeByte((int)TablePrefix.TABLE.getValue());
        beginKey.writeShort((int)TableId.SUBSCRIPTION_GROUP.getValue());
        beginKey.writeByte((int)RecordPrefix.DATA.getValue());
        ByteBuf endKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        endKey.writeByte((int)TablePrefix.TABLE.getValue());
        endKey.writeShort((int)TableId.SUBSCRIPTION_GROUP.getValue());
        endKey.writeByte(RecordPrefix.DATA.getValue() + 1);
        try (RocksIterator iterator = this.configStorage.iterate(beginKey.nioBuffer(), endKey.nioBuffer());){
            while (iterator.isValid()) {
                SubscriptionGroupConfig subscriptionGroupConfig = this.parseSubscription(iterator.key(), iterator.value());
                if (null != subscriptionGroupConfig) {
                    super.putSubscriptionGroupConfig(subscriptionGroupConfig);
                }
                iterator.next();
            }
        }
        finally {
            beginKey.release();
            endKey.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionGroupConfig parseSubscription(byte[] key, byte[] value) {
        ByteBuf keyBuf = Unpooled.wrappedBuffer((byte[])key);
        ByteBuf valueBuf = Unpooled.wrappedBuffer((byte[])value);
        try {
            keyBuf.readerIndex(4);
            short groupNameLen = keyBuf.readShort();
            assert (groupNameLen == keyBuf.readableBytes());
            CharSequence groupName = keyBuf.readCharSequence((int)groupNameLen, StandardCharsets.UTF_8);
            assert (null != groupName);
            byte serializationType = valueBuf.readByte();
            if (SerializationType.JSON == SerializationType.valueOf(serializationType)) {
                CharSequence json = valueBuf.readCharSequence(valueBuf.readableBytes(), StandardCharsets.UTF_8);
                SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)JSON.parseObject((String)json.toString(), SubscriptionGroupConfig.class);
                assert (subscriptionGroupConfig != null);
                assert (groupName.equals(subscriptionGroupConfig.getGroupName()));
                SubscriptionGroupConfig subscriptionGroupConfig2 = subscriptionGroupConfig;
                return subscriptionGroupConfig2;
            }
        }
        finally {
            keyBuf.release();
            valueBuf.release();
        }
        return null;
    }

    public synchronized void persist() {
        try {
            this.configStorage.flushWAL();
        }
        catch (RocksDBException e) {
            log.error("Failed to flush RocksDB WAL", (Throwable)e);
        }
    }

    @Override
    public SubscriptionGroupConfig findSubscriptionGroupConfig(String group) {
        if (MixAll.isLmq((String)group)) {
            SubscriptionGroupConfig subscriptionGroupConfig = new SubscriptionGroupConfig();
            subscriptionGroupConfig.setGroupName(group);
            return subscriptionGroupConfig;
        }
        return super.findSubscriptionGroupConfig(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubscriptionGroupConfig(SubscriptionGroupConfig config) {
        if (config == null || MixAll.isLmq((String)config.getGroupName())) {
            return;
        }
        super.updateSubscriptionGroupConfigWithoutPersist(config);
        ByteBuf keyBuf = ConfigHelper.keyBufOf(TableId.SUBSCRIPTION_GROUP, config.getGroupName());
        ByteBuf valueBuf = ConfigHelper.valueBufOf(config, SerializationType.JSON);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.put(keyBuf.nioBuffer(), valueBuf.nioBuffer());
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            ConfigHelper.stampDataVersion(writeBatch, TableId.SUBSCRIPTION_GROUP, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
            this.persist();
        }
        catch (RocksDBException e) {
            log.error("update subscription group config error", (Throwable)e);
        }
        finally {
            keyBuf.release();
            valueBuf.release();
        }
    }

    @Override
    public boolean containsSubscriptionGroup(String group) {
        if (MixAll.isLmq((String)group)) {
            return true;
        }
        return super.containsSubscriptionGroup(group);
    }

    @Override
    protected SubscriptionGroupConfig removeSubscriptionGroupConfig(String groupName) {
        ByteBuf keyBuf = ConfigHelper.keyBufOf(TableId.SUBSCRIPTION_GROUP, groupName);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.delete(ConfigHelper.readBytes(keyBuf));
            long stateMachineVersion = this.brokerController.getMessageStore().getStateMachineVersion();
            ConfigHelper.stampDataVersion(writeBatch, TableId.SUBSCRIPTION_GROUP, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
        }
        catch (RocksDBException e) {
            log.error("Failed to remove subscription group config by group-name={}", (Object)groupName, (Object)e);
        }
        return super.removeSubscriptionGroupConfig(groupName);
    }
}

