/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.filestore.FileStore;
import org.apache.ratis.examples.filestore.FileStoreCommon;
import org.apache.ratis.proto.ExamplesProtos;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.FileUtils;

public class FileStoreStateMachine
extends BaseStateMachine {
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final FileStore files;

    public FileStoreStateMachine(RaftProperties properties) {
        this.files = new FileStore(this::getId, properties);
    }

    @Override
    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
        super.initialize(server, groupId, raftStorage);
        this.storage.init(raftStorage);
        for (Path path : this.files.getRoots()) {
            FileUtils.createDirectories(path);
        }
    }

    @Override
    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    @Override
    public void close() {
        this.files.close();
        this.setLastAppliedTermIndex(null);
    }

    @Override
    public CompletableFuture<Message> query(Message request) {
        ExamplesProtos.ReadRequestProto proto;
        try {
            proto = ExamplesProtos.ReadRequestProto.parseFrom(request.getContent());
        }
        catch (InvalidProtocolBufferException e) {
            return FileStoreCommon.completeExceptionally("Failed to parse " + request, e);
        }
        String path = proto.getPath().toStringUtf8();
        return (proto.getIsWatch() ? this.files.watch(path) : this.files.read(path, proto.getOffset(), proto.getLength(), true)).thenApply(reply -> Message.valueOf(reply.toByteString()));
    }

    @Override
    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        ByteString content = request.getMessage().getContent();
        ExamplesProtos.FileStoreRequestProto proto = ExamplesProtos.FileStoreRequestProto.parseFrom(content);
        TransactionContext.Builder b = TransactionContext.newBuilder().setStateMachine(this).setClientRequest(request);
        if (proto.getRequestCase() == ExamplesProtos.FileStoreRequestProto.RequestCase.WRITE) {
            ExamplesProtos.WriteRequestProto write = proto.getWrite();
            ExamplesProtos.FileStoreRequestProto newProto = ExamplesProtos.FileStoreRequestProto.newBuilder().setWriteHeader(write.getHeader()).build();
            b.setLogData(newProto.toByteString()).setStateMachineData(write.getData()).setStateMachineContext(newProto);
        } else {
            b.setLogData(content).setStateMachineContext(proto);
        }
        return b.build();
    }

    @Override
    public TransactionContext startTransaction(RaftProtos.LogEntryProto entry, RaftProtos.RaftPeerRole role) {
        return TransactionContext.newBuilder().setStateMachine(this).setLogEntry(entry).setServerRole(role).setStateMachineContext(FileStoreStateMachine.getProto(entry)).build();
    }

    public CompletableFuture<Integer> write(RaftProtos.LogEntryProto entry, TransactionContext context) {
        ExamplesProtos.FileStoreRequestProto proto = FileStoreStateMachine.getProto(context, entry);
        if (proto.getRequestCase() != ExamplesProtos.FileStoreRequestProto.RequestCase.WRITEHEADER) {
            return null;
        }
        ExamplesProtos.WriteRequestHeaderProto h2 = proto.getWriteHeader();
        CompletableFuture<Integer> f = this.files.write(entry.getIndex(), h2.getPath().toStringUtf8(), h2.getClose(), h2.getSync(), h2.getOffset(), entry.getStateMachineLogEntry().getStateMachineEntry().getStateMachineData());
        return h2.getClose() ? f : null;
    }

    static ExamplesProtos.FileStoreRequestProto getProto(TransactionContext context, RaftProtos.LogEntryProto entry) {
        ExamplesProtos.FileStoreRequestProto proto;
        if (context != null && (proto = (ExamplesProtos.FileStoreRequestProto)context.getStateMachineContext()) != null) {
            return proto;
        }
        return FileStoreStateMachine.getProto(entry);
    }

    static ExamplesProtos.FileStoreRequestProto getProto(RaftProtos.LogEntryProto entry) {
        try {
            return ExamplesProtos.FileStoreRequestProto.parseFrom(entry.getStateMachineLogEntry().getLogData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Failed to parse data, entry=" + entry, e);
        }
    }

    @Override
    public CompletableFuture<ByteString> read(RaftProtos.LogEntryProto entry, TransactionContext context) {
        ExamplesProtos.FileStoreRequestProto proto = FileStoreStateMachine.getProto(context, entry);
        if (proto.getRequestCase() != ExamplesProtos.FileStoreRequestProto.RequestCase.WRITEHEADER) {
            return null;
        }
        ExamplesProtos.WriteRequestHeaderProto h2 = proto.getWriteHeader();
        CompletableFuture<ExamplesProtos.ReadReplyProto> reply = this.files.read(h2.getPath().toStringUtf8(), h2.getOffset(), h2.getLength(), false);
        return reply.thenApply(ExamplesProtos.ReadReplyProto::getData);
    }

    @Override
    public CompletableFuture<StateMachine.DataStream> stream(RaftClientRequest request) {
        ExamplesProtos.FileStoreRequestProto proto;
        ByteString reqByteString = request.getMessage().getContent();
        try {
            proto = ExamplesProtos.FileStoreRequestProto.parseFrom(reqByteString);
        }
        catch (InvalidProtocolBufferException e) {
            return FileStoreCommon.completeExceptionally("Failed to parse stream header", e);
        }
        return this.files.createDataChannel(proto.getStream().getPath().toStringUtf8()).thenApply(LocalStream::new);
    }

    @Override
    public CompletableFuture<?> link(StateMachine.DataStream stream, RaftProtos.LogEntryProto entry) {
        LOG.info("linking {}", (Object)stream);
        return this.files.streamLink(stream);
    }

    @Override
    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        RaftProtos.LogEntryProto entry = trx.getLogEntry();
        long index = entry.getIndex();
        this.updateLastAppliedTermIndex(entry.getTerm(), index);
        ExamplesProtos.FileStoreRequestProto request = FileStoreStateMachine.getProto(trx, entry);
        switch (request.getRequestCase()) {
            case DELETE: {
                return this.delete(index, request.getDelete());
            }
            case WRITEHEADER: {
                return this.writeCommit(index, request.getWriteHeader(), entry.getStateMachineLogEntry().getStateMachineEntry().getStateMachineData().size());
            }
            case STREAM: {
                return this.streamCommit(request.getStream());
            }
        }
        LOG.error(this.getId() + ": Unexpected request case " + request.getRequestCase());
        return FileStoreCommon.completeExceptionally(index, "Unexpected request case " + request.getRequestCase());
    }

    private CompletableFuture<Message> writeCommit(long index, ExamplesProtos.WriteRequestHeaderProto header, int size) {
        String path = header.getPath().toStringUtf8();
        return this.files.submitCommit(index, path, header.getClose(), header.getOffset(), size).thenApply(reply -> Message.valueOf(reply.toByteString()));
    }

    private CompletableFuture<Message> streamCommit(ExamplesProtos.StreamWriteRequestProto stream) {
        String path = stream.getPath().toStringUtf8();
        long size = stream.getLength();
        return this.files.streamCommit(path, size).thenApply(reply -> Message.valueOf(reply.toByteString()));
    }

    private CompletableFuture<Message> delete(long index, ExamplesProtos.DeleteRequestProto request) {
        String path = request.getPath().toStringUtf8();
        return this.files.delete(index, path).thenApply(resolved -> Message.valueOf(ExamplesProtos.DeleteReplyProto.newBuilder().setResolvedPath(FileStoreCommon.toByteString(resolved)).build().toByteString(), () -> "Message:" + resolved));
    }

    static class LocalStream
    implements StateMachine.DataStream {
        private final StateMachine.DataChannel dataChannel;

        LocalStream(StateMachine.DataChannel dataChannel) {
            this.dataChannel = dataChannel;
        }

        @Override
        public StateMachine.DataChannel getDataChannel() {
            return this.dataChannel;
        }

        @Override
        public CompletableFuture<?> cleanUp() {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    this.dataChannel.close();
                    return true;
                }
                catch (IOException e) {
                    return FileStoreCommon.completeExceptionally("Failed to close data channel", e);
                }
            });
        }
    }
}

