/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ContainerServiceInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ContainerServicesInner
implements InnerSupportsGet<ContainerServiceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ContainerServiceInner> {
    private ContainerServicesService service;
    private ComputeManagementClientImpl client;

    public ContainerServicesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (ContainerServicesService)retrofit.create(ContainerServicesService.class);
        this.client = client;
    }

    public PagedList<ContainerServiceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ContainerServiceInner>((Page)response.body()){

            public Page<ContainerServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerServicesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerServiceInner>> listAsync(ListOperationCallback<ContainerServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(String nextPageLink) {
                return ContainerServicesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerServiceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Page<ContainerServiceInner>>(){

            public Page<ContainerServiceInner> call(ServiceResponse<Page<ContainerServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(ServiceResponse<Page<ContainerServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerServicesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-01-31";
        return this.service.list(this.client.subscriptionId(), "2017-01-31", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerServicesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ContainerServiceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ContainerServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerServiceInner createOrUpdate(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters) {
        return (ContainerServiceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, containerServiceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ContainerServiceInner> createOrUpdateAsync(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters, ServiceCallback<ContainerServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, containerServiceName, parameters), serviceCallback);
    }

    public Observable<ContainerServiceInner> createOrUpdateAsync(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, containerServiceName, parameters).map((Func1)new Func1<ServiceResponse<ContainerServiceInner>, ContainerServiceInner>(){

            public ContainerServiceInner call(ServiceResponse<ContainerServiceInner> response) {
                return (ContainerServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerServiceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerServiceName == null) {
            throw new IllegalArgumentException("Parameter containerServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-01-31";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, containerServiceName, this.client.subscriptionId(), parameters, "2017-01-31", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ContainerServiceInner>(){}.getType());
    }

    public ContainerServiceInner beginCreateOrUpdate(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters) {
        return (ContainerServiceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, containerServiceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters, ServiceCallback<ContainerServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, containerServiceName, parameters), serviceCallback);
    }

    public Observable<ContainerServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, containerServiceName, parameters).map((Func1)new Func1<ServiceResponse<ContainerServiceInner>, ContainerServiceInner>(){

            public ContainerServiceInner call(ServiceResponse<ContainerServiceInner> response) {
                return (ContainerServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerServiceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String containerServiceName, ContainerServiceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerServiceName == null) {
            throw new IllegalArgumentException("Parameter containerServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-01-31";
        return this.service.beginCreateOrUpdate(resourceGroupName, containerServiceName, this.client.subscriptionId(), parameters, "2017-01-31", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerServiceInner>>>(){

            public Observable<ServiceResponse<ContainerServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerServicesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerServiceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerServiceInner>(){}.getType()).register(201, new TypeToken<ContainerServiceInner>(){}.getType()).register(202, new TypeToken<ContainerServiceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerServiceInner getByResourceGroup(String resourceGroupName, String containerServiceName) {
        return (ContainerServiceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, containerServiceName).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerServiceInner> getByResourceGroupAsync(String resourceGroupName, String containerServiceName, ServiceCallback<ContainerServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, containerServiceName), serviceCallback);
    }

    public Observable<ContainerServiceInner> getByResourceGroupAsync(String resourceGroupName, String containerServiceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, containerServiceName).map((Func1)new Func1<ServiceResponse<ContainerServiceInner>, ContainerServiceInner>(){

            public ContainerServiceInner call(ServiceResponse<ContainerServiceInner> response) {
                return (ContainerServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerServiceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String containerServiceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerServiceName == null) {
            throw new IllegalArgumentException("Parameter containerServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-01-31";
        return this.service.getByResourceGroup(resourceGroupName, containerServiceName, this.client.subscriptionId(), "2017-01-31", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerServiceInner>>>(){

            public Observable<ServiceResponse<ContainerServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerServicesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerServiceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerServiceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String containerServiceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, containerServiceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String containerServiceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, containerServiceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String containerServiceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, containerServiceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String containerServiceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerServiceName == null) {
            throw new IllegalArgumentException("Parameter containerServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-01-31";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, containerServiceName, this.client.subscriptionId(), "2017-01-31", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String containerServiceName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, containerServiceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String containerServiceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, containerServiceName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String containerServiceName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, containerServiceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String containerServiceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerServiceName == null) {
            throw new IllegalArgumentException("Parameter containerServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-01-31";
        return this.service.beginDelete(resourceGroupName, containerServiceName, this.client.subscriptionId(), "2017-01-31", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerServicesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ContainerServiceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ContainerServiceInner>((Page)response.body()){

            public Page<ContainerServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerServiceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ContainerServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(String nextPageLink) {
                return ContainerServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerServiceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Page<ContainerServiceInner>>(){

            public Page<ContainerServiceInner> call(ServiceResponse<Page<ContainerServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(ServiceResponse<Page<ContainerServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerServicesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-01-31";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2017-01-31", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerServicesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ContainerServiceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ContainerServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ContainerServiceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ContainerServiceInner>((Page)response.body()){

            public Page<ContainerServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerServicesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerServiceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ContainerServiceInner>> serviceFuture, ListOperationCallback<ContainerServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(String nextPageLink) {
                return ContainerServicesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerServiceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Page<ContainerServiceInner>>(){

            public Page<ContainerServiceInner> call(ServiceResponse<Page<ContainerServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(ServiceResponse<Page<ContainerServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerServicesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerServicesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ContainerServiceInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ContainerServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ContainerServiceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ContainerServiceInner>((Page)response.body()){

            public Page<ContainerServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerServiceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ContainerServiceInner>> serviceFuture, ListOperationCallback<ContainerServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(String nextPageLink) {
                return ContainerServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerServiceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Page<ContainerServiceInner>>(){

            public Page<ContainerServiceInner> call(ServiceResponse<Page<ContainerServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ContainerServiceInner>>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(ServiceResponse<Page<ContainerServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerServicesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerServiceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerServiceInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerServicesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ContainerServiceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ContainerServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ContainerServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/containerServices")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="containerServiceName") String var2, @Path(value="subscriptionId") String var3, @Body ContainerServiceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="containerServiceName") String var2, @Path(value="subscriptionId") String var3, @Body ContainerServiceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="containerServiceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="containerServiceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="containerServiceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.ContainerServices listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

