/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.cryptography.Algorithm;
import com.microsoft.azure.keyvault.cryptography.AlgorithmResolver;
import com.microsoft.azure.keyvault.cryptography.AsymmetricSignatureAlgorithm;
import com.microsoft.azure.keyvault.cryptography.ISignatureTransform;
import com.microsoft.azure.keyvault.cryptography.Strings;
import com.microsoft.azure.keyvault.cryptography.algorithms.Ecdsa;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyCurveName;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class EcKey
implements IKey {
    public static final String P256 = "secp256r1";
    public static final String P384 = "secp384r1";
    public static final String P521 = "secp521r1";
    public static final String P256K = "secp256k1";
    public static final Map<JsonWebKeyCurveName, String> CURVE_TO_SIGNATURE = ImmutableMap.builder().put((Object)JsonWebKeyCurveName.P_256, (Object)"ES256").put((Object)JsonWebKeyCurveName.P_384, (Object)"ES384").put((Object)JsonWebKeyCurveName.P_521, (Object)"ES512").put((Object)JsonWebKeyCurveName.P_256K, (Object)"ES256K").build();
    public static final Map<JsonWebKeyCurveName, String> CURVE_TO_SPEC_NAME = ImmutableMap.builder().put((Object)JsonWebKeyCurveName.P_256, (Object)"secp256r1").put((Object)JsonWebKeyCurveName.P_384, (Object)"secp384r1").put((Object)JsonWebKeyCurveName.P_521, (Object)"secp521r1").put((Object)JsonWebKeyCurveName.P_256K, (Object)"secp256k1").build();
    private final String kid;
    private final KeyPair keyPair;
    private final Provider provider;
    private final JsonWebKeyCurveName curve;
    protected final String signatureAlgorithm;
    protected String defaultEncryptionAlgorithm;

    public static JsonWebKeyCurveName getDefaultCurve() {
        return JsonWebKeyCurveName.P_256;
    }

    public EcKey() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this(UUID.randomUUID().toString());
    }

    public EcKey(String kid) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this(kid, EcKey.getDefaultCurve(), Security.getProvider("SunEC"));
    }

    public EcKey(String kid, JsonWebKeyCurveName curve) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this(kid, curve, Security.getProvider("SunEC"));
    }

    public EcKey(String kid, JsonWebKeyCurveName curve, Provider provider) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        this.kid = kid;
        this.provider = provider;
        this.curve = curve;
        this.signatureAlgorithm = CURVE_TO_SIGNATURE.get(curve);
        if (this.signatureAlgorithm == null) {
            throw new NoSuchAlgorithmException("Curve not supported.");
        }
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC", provider);
        ECGenParameterSpec gps = new ECGenParameterSpec(CURVE_TO_SPEC_NAME.get(curve));
        generator.initialize(gps);
        this.keyPair = generator.generateKeyPair();
    }

    public EcKey(String kid, KeyPair keyPair) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this(kid, keyPair, Security.getProvider("SunEC"));
    }

    public EcKey(String kid, KeyPair keyPair, Provider provider) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("Please provide a kid");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("Please provide an ECKey");
        }
        if (keyPair.getPublic() == null || !(keyPair.getPublic() instanceof ECPublicKey)) {
            throw new IllegalArgumentException("The keyPair provided is not an ECKey");
        }
        this.kid = kid;
        this.keyPair = keyPair;
        this.provider = provider;
        this.curve = this.getCurveFromKeyPair(keyPair);
        this.signatureAlgorithm = CURVE_TO_SIGNATURE.get(this.curve);
        if (this.signatureAlgorithm == null) {
            throw new IllegalArgumentException("Curve not supported.");
        }
    }

    public static EcKey fromJsonWebKey(JsonWebKey jwk) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeySpecException, NoSuchProviderException {
        return EcKey.fromJsonWebKey(jwk, false, null);
    }

    public static EcKey fromJsonWebKey(JsonWebKey jwk, boolean includePrivateParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeySpecException, NoSuchProviderException {
        return EcKey.fromJsonWebKey(jwk, includePrivateParameters, null);
    }

    public static EcKey fromJsonWebKey(JsonWebKey jwk, boolean includePrivateParameters, Provider provider) {
        try {
            if (jwk.kid() != null) {
                return new EcKey(jwk.kid(), jwk.toEC(includePrivateParameters, provider));
            }
            throw new IllegalArgumentException("Json Web Key should have a kid");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public JsonWebKey toJsonWebKey() {
        return JsonWebKey.fromEC((KeyPair)this.keyPair, (Provider)this.provider);
    }

    private JsonWebKeyCurveName getCurveFromKeyPair(KeyPair keyPair) {
        try {
            ECPublicKey key = (ECPublicKey)keyPair.getPublic();
            ECParameterSpec spec = key.getParams();
            EllipticCurve crv = spec.getCurve();
            List<JsonWebKeyCurveName> curveList = Arrays.asList(JsonWebKeyCurveName.P_256, JsonWebKeyCurveName.P_384, JsonWebKeyCurveName.P_521, JsonWebKeyCurveName.P_256K);
            for (JsonWebKeyCurveName curve : curveList) {
                ECGenParameterSpec gps = new ECGenParameterSpec(CURVE_TO_SPEC_NAME.get(curve));
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", this.provider);
                kpg.initialize(gps);
                KeyPair apair = kpg.generateKeyPair();
                ECPublicKey apub = (ECPublicKey)apair.getPublic();
                ECParameterSpec aspec = apub.getParams();
                EllipticCurve acurve = aspec.getCurve();
                if (!acurve.equals(crv)) continue;
                return curve;
            }
            throw new IllegalArgumentException("Curve not supported.");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public JsonWebKeyCurveName getCurve() {
        return this.curve;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void close() throws IOException {
    }

    public String getDefaultEncryptionAlgorithm() {
        return null;
    }

    public String getDefaultKeyWrapAlgorithm() {
        return null;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getKid() {
        return this.kid;
    }

    public ListenableFuture<byte[]> decryptAsync(byte[] ciphertext, byte[] iv, byte[] authenticationData, byte[] authenticationTag, String algorithm) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException("Decrypt Async is not supported");
    }

    public ListenableFuture<Triple<byte[], byte[], String>> encryptAsync(byte[] plaintext, byte[] iv, byte[] authenticationData, String algorithm) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException("Encrypt Async is not supported");
    }

    public ListenableFuture<Pair<byte[], String>> wrapKeyAsync(byte[] key, String algorithm) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException("Wrap key is not supported");
    }

    public ListenableFuture<byte[]> unwrapKeyAsync(byte[] encryptedKey, String algorithm) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException("Unwrap key is not supported");
    }

    public ListenableFuture<Pair<byte[], String>> signAsync(byte[] digest, String algorithm) throws NoSuchAlgorithmException {
        if (this.keyPair.getPrivate() == null) {
            throw new UnsupportedOperationException("Sign is not supported without a private key.");
        }
        if (digest == null) {
            throw new IllegalArgumentException("Please provide a digest to sign.");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("Please provide a signature algorithm to use.");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return Futures.immediateFuture((Object)Pair.of((Object)signer.sign(digest), (Object)algorithm));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<Boolean> verifyAsync(byte[] digest, byte[] signature, String algorithm) throws NoSuchAlgorithmException {
        if (digest == null) {
            throw new IllegalArgumentException("Please provide a digest input.");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("Please provide an algorithm");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return Futures.immediateFuture((Object)signer.verify(digest, signature));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }
}

