/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.HubVirtualNetworkConnectionInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class HubVirtualNetworkConnectionsInner {
    private HubVirtualNetworkConnectionsService service;
    private NetworkManagementClientImpl client;

    public HubVirtualNetworkConnectionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (HubVirtualNetworkConnectionsService)retrofit.create(HubVirtualNetworkConnectionsService.class);
        this.client = client;
    }

    public HubVirtualNetworkConnectionInner get(String resourceGroupName, String virtualHubName, String connectionName) {
        return (HubVirtualNetworkConnectionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, virtualHubName, connectionName).toBlocking().single()).body());
    }

    public ServiceFuture<HubVirtualNetworkConnectionInner> getAsync(String resourceGroupName, String virtualHubName, String connectionName, ServiceCallback<HubVirtualNetworkConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, virtualHubName, connectionName), serviceCallback);
    }

    public Observable<HubVirtualNetworkConnectionInner> getAsync(String resourceGroupName, String virtualHubName, String connectionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, virtualHubName, connectionName).map((Func1)new Func1<ServiceResponse<HubVirtualNetworkConnectionInner>, HubVirtualNetworkConnectionInner>(){

            public HubVirtualNetworkConnectionInner call(ServiceResponse<HubVirtualNetworkConnectionInner> response) {
                return (HubVirtualNetworkConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<HubVirtualNetworkConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String connectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, virtualHubName, connectionName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<HubVirtualNetworkConnectionInner>>>(){

            public Observable<ServiceResponse<HubVirtualNetworkConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = HubVirtualNetworkConnectionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<HubVirtualNetworkConnectionInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<HubVirtualNetworkConnectionInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<HubVirtualNetworkConnectionInner> list(String resourceGroupName, String virtualHubName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, virtualHubName).toBlocking().single();
        return new PagedList<HubVirtualNetworkConnectionInner>((Page)response.body()){

            public Page<HubVirtualNetworkConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)HubVirtualNetworkConnectionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<HubVirtualNetworkConnectionInner>> listAsync(String resourceGroupName, String virtualHubName, ListOperationCallback<HubVirtualNetworkConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, virtualHubName), (Func1)new Func1<String, Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> call(String nextPageLink) {
                return HubVirtualNetworkConnectionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<HubVirtualNetworkConnectionInner>> listAsync(String resourceGroupName, String virtualHubName) {
        return this.listWithServiceResponseAsync(resourceGroupName, virtualHubName).map((Func1)new Func1<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>, Page<HubVirtualNetworkConnectionInner>>(){

            public Page<HubVirtualNetworkConnectionInner> call(ServiceResponse<Page<HubVirtualNetworkConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> listWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        return this.listSinglePageAsync(resourceGroupName, virtualHubName).concatMap((Func1)new Func1<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>, Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> call(ServiceResponse<Page<HubVirtualNetworkConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(HubVirtualNetworkConnectionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> listSinglePageAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = HubVirtualNetworkConnectionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<HubVirtualNetworkConnectionInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<HubVirtualNetworkConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<HubVirtualNetworkConnectionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<HubVirtualNetworkConnectionInner>((Page)response.body()){

            public Page<HubVirtualNetworkConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)HubVirtualNetworkConnectionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<HubVirtualNetworkConnectionInner>> listNextAsync(String nextPageLink, ServiceFuture<List<HubVirtualNetworkConnectionInner>> serviceFuture, ListOperationCallback<HubVirtualNetworkConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> call(String nextPageLink) {
                return HubVirtualNetworkConnectionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<HubVirtualNetworkConnectionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>, Page<HubVirtualNetworkConnectionInner>>(){

            public Page<HubVirtualNetworkConnectionInner> call(ServiceResponse<Page<HubVirtualNetworkConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>, Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> call(ServiceResponse<Page<HubVirtualNetworkConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(HubVirtualNetworkConnectionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<HubVirtualNetworkConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = HubVirtualNetworkConnectionsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<HubVirtualNetworkConnectionInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<HubVirtualNetworkConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface HubVirtualNetworkConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.HubVirtualNetworkConnections get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections/{connectionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Path(value="connectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.HubVirtualNetworkConnections list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.HubVirtualNetworkConnections listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

