/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FSLinkResolver;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FsLinkResolution<T>
extends FSLinkResolver<T> {
    private final FsLinkResolutionFunction<T> fn;

    public FsLinkResolution(FsLinkResolutionFunction<T> fn) {
        this.fn = (FsLinkResolutionFunction)Preconditions.checkNotNull(fn);
    }

    @Override
    public T next(AbstractFileSystem fs, Path p) throws UnresolvedLinkException, IOException {
        return this.fn.apply(fs, p);
    }

    public static <T> T resolve(FileContext fileContext, Path path, FsLinkResolutionFunction<T> fn) throws UnresolvedLinkException, IOException {
        return new FsLinkResolution<T>(fn).resolve(fileContext, path);
    }

    @FunctionalInterface
    public static interface FsLinkResolutionFunction<T> {
        public T apply(AbstractFileSystem var1, Path var2) throws IOException, UnresolvedLinkException;
    }
}

