/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.presto.authorizer;

import io.prestosql.spi.connector.SchemaTableName;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;

class RangerPrestoResource
extends RangerAccessResourceImpl {
    public static final String KEY_CATALOG = "catalog";
    public static final String KEY_SCHEMA = "schema";
    public static final String KEY_TABLE = "table";
    public static final String KEY_COLUMN = "column";
    public static final String KEY_USER = "prestouser";
    public static final String KEY_FUNCTION = "function";
    public static final String KEY_PROCEDURE = "procedure";
    public static final String KEY_SYSTEM_PROPERTY = "systemproperty";
    public static final String KEY_SESSION_PROPERTY = "sessionproperty";

    public RangerPrestoResource() {
    }

    public RangerPrestoResource(String catalogName, Optional<String> schema, Optional<String> table) {
        this.setValue(KEY_CATALOG, catalogName);
        if (schema.isPresent()) {
            this.setValue(KEY_SCHEMA, schema.get());
        }
        if (table.isPresent()) {
            this.setValue(KEY_TABLE, table.get());
        }
    }

    public RangerPrestoResource(String catalogName, Optional<String> schema, Optional<String> table, Optional<String> column) {
        this.setValue(KEY_CATALOG, catalogName);
        if (schema.isPresent()) {
            this.setValue(KEY_SCHEMA, schema.get());
        }
        if (table.isPresent()) {
            this.setValue(KEY_TABLE, table.get());
        }
        if (column.isPresent()) {
            this.setValue(KEY_COLUMN, column.get());
        }
    }

    public String getCatalogName() {
        return (String)this.getValue(KEY_CATALOG);
    }

    public String getTable() {
        return (String)this.getValue(KEY_TABLE);
    }

    public String getCatalog() {
        return (String)this.getValue(KEY_CATALOG);
    }

    public String getSchema() {
        return (String)this.getValue(KEY_SCHEMA);
    }

    public Optional<SchemaTableName> getSchemaTable() {
        String schema = this.getSchema();
        if (StringUtils.isNotEmpty((String)schema)) {
            return Optional.of(new SchemaTableName(schema, Optional.ofNullable(this.getTable()).orElse("*")));
        }
        return Optional.empty();
    }
}

