/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.Immutable;
import io.trino.spi.type.ParameterKind;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

@Immutable
public final class TypeSignature {
    private static final String TIMESTAMP_WITH_TIME_ZONE = "timestamp with time zone";
    private static final String TIMESTAMP_WITHOUT_TIME_ZONE = "timestamp without time zone";
    private final String base;
    private final List<TypeSignatureParameter> parameters;
    private final boolean calculated;
    private int hashCode;

    public TypeSignature(String base, TypeSignatureParameter ... parameters) {
        this(base, Arrays.asList(parameters));
    }

    public TypeSignature(String base, List<TypeSignatureParameter> parameters) {
        TypeSignature.checkArgument(base != null, "base is null", new Object[0]);
        this.base = base;
        TypeSignature.checkArgument(!base.isEmpty(), "base is empty", new Object[0]);
        TypeSignature.checkArgument(TypeSignature.validateName(base), "Bad characters in base type: %s", base);
        TypeSignature.checkArgument(parameters != null, "parameters is null", new Object[0]);
        this.parameters = List.copyOf(parameters);
        this.calculated = parameters.stream().anyMatch(TypeSignatureParameter::isCalculated);
    }

    public String getBase() {
        return this.base;
    }

    public List<TypeSignatureParameter> getParameters() {
        return this.parameters;
    }

    public List<TypeSignature> getTypeParametersAsTypeSignatures() {
        ArrayList<TypeSignature> result = new ArrayList<TypeSignature>();
        for (TypeSignatureParameter parameter : this.parameters) {
            if (parameter.getKind() != ParameterKind.TYPE) {
                throw new IllegalStateException(String.format("Expected all parameters to be TypeSignatures but [%s] was found", parameter));
            }
            result.add(parameter.getTypeSignature());
        }
        return result;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public String toString() {
        return this.formatValue(false);
    }

    @JsonValue
    public String jsonValue() {
        return this.formatValue(true);
    }

    private String formatValue(boolean json) {
        if (this.parameters.isEmpty()) {
            return this.base;
        }
        if (this.base.equalsIgnoreCase("varchar") && this.parameters.size() == 1 && this.parameters.get(0).isLongLiteral() && this.parameters.get(0).getLongLiteral() == Integer.MAX_VALUE) {
            return this.base;
        }
        if (this.base.equalsIgnoreCase(TIMESTAMP_WITH_TIME_ZONE)) {
            return String.format("timestamp(%s) with time zone", this.parameters.get(0));
        }
        if (this.base.equalsIgnoreCase(TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return String.format("timestamp(%s) without time zone", this.parameters.get(0));
        }
        if (this.base.equalsIgnoreCase("time with time zone")) {
            return String.format("time(%s) with time zone", this.parameters.get(0));
        }
        StringBuilder typeName = new StringBuilder(this.base);
        typeName.append("(").append(json ? this.parameters.get(0).jsonValue() : this.parameters.get(0).toString());
        for (int i = 1; i < this.parameters.size(); ++i) {
            typeName.append(",").append(json ? this.parameters.get(i).jsonValue() : this.parameters.get(i).toString());
        }
        typeName.append(")");
        return typeName.toString();
    }

    @FormatMethod
    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    private static boolean validateName(String name) {
        return name.chars().noneMatch(c -> c == 60 || c == 62 || c == 44);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignature other = (TypeSignature)o;
        return Objects.equals(this.base.toLowerCase(Locale.ENGLISH), other.base.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = Objects.hash(this.base.toLowerCase(Locale.ENGLISH), this.parameters);
            if (hash == 0) {
                hash = 1;
            }
            this.hashCode = hash;
        }
        return hash;
    }

    public static TypeSignature arrayType(TypeSignature elementType) {
        return new TypeSignature("array", TypeSignatureParameter.typeParameter(elementType));
    }

    public static TypeSignature arrayType(TypeSignatureParameter elementType) {
        return new TypeSignature("array", elementType);
    }

    public static TypeSignature mapType(TypeSignature keyType, TypeSignature valueType) {
        return new TypeSignature("map", TypeSignatureParameter.typeParameter(keyType), TypeSignatureParameter.typeParameter(valueType));
    }

    public static TypeSignature parametricType(String name, TypeSignature ... parameters) {
        return new TypeSignature(name, Arrays.stream(parameters).map(TypeSignatureParameter::typeParameter).collect(Collectors.toUnmodifiableList()));
    }

    public static TypeSignature functionType(TypeSignature first, TypeSignature ... rest) {
        ArrayList<TypeSignatureParameter> parameters = new ArrayList<TypeSignatureParameter>();
        parameters.add(TypeSignatureParameter.typeParameter(first));
        Arrays.stream(rest).map(TypeSignatureParameter::typeParameter).forEach(parameters::add);
        return new TypeSignature("function", parameters);
    }

    public static TypeSignature rowType(TypeSignatureParameter ... fields) {
        return TypeSignature.rowType(Arrays.asList(fields));
    }

    public static TypeSignature rowType(List<TypeSignatureParameter> fields) {
        TypeSignature.checkArgument(fields.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.NAMED_TYPE), "Parameters for ROW type must be NAMED_TYPE parameters", new Object[0]);
        return new TypeSignature("row", fields);
    }
}

