/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.DoNotCall;
import io.trino.spi.Experimental;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Experimental(eta="2022-10-31")
public class TypeVariableConstraint {
    private final String name;
    private final boolean comparableRequired;
    private final boolean orderableRequired;
    private final Optional<String> variadicBound;
    private final Set<TypeSignature> castableTo;
    private final Set<TypeSignature> castableFrom;

    private TypeVariableConstraint(String name, boolean comparableRequired, boolean orderableRequired, Optional<String> variadicBound, Set<TypeSignature> castableTo, Set<TypeSignature> castableFrom) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.comparableRequired = comparableRequired;
        this.orderableRequired = orderableRequired;
        this.variadicBound = Objects.requireNonNull(variadicBound, "variadicBound is null");
        if (variadicBound.map(bound -> !bound.equalsIgnoreCase("row")).orElse(false).booleanValue()) {
            throw new IllegalArgumentException("variadicBound must be row but is " + variadicBound.get());
        }
        this.castableTo = Set.copyOf((Collection)Objects.requireNonNull(castableTo, "castableTo is null"));
        this.castableFrom = Set.copyOf((Collection)Objects.requireNonNull(castableFrom, "castableFrom is null"));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isComparableRequired() {
        return this.comparableRequired;
    }

    @JsonProperty
    public boolean isOrderableRequired() {
        return this.orderableRequired;
    }

    @JsonProperty
    public Optional<String> getVariadicBound() {
        return this.variadicBound;
    }

    @JsonProperty
    public Set<TypeSignature> getCastableTo() {
        return this.castableTo;
    }

    @JsonProperty
    public Set<TypeSignature> getCastableFrom() {
        return this.castableFrom;
    }

    public String toString() {
        Object value = this.name;
        if (this.comparableRequired) {
            value = (String)value + ":comparable";
        }
        if (this.orderableRequired) {
            value = (String)value + ":orderable";
        }
        if (this.variadicBound.isPresent()) {
            value = (String)value + ":" + String.valueOf(this.variadicBound) + "<*>";
        }
        if (!this.castableTo.isEmpty()) {
            value = (String)value + this.castableTo.stream().map(Object::toString).collect(Collectors.joining(", ", ":castableTo(", ")"));
        }
        if (!this.castableFrom.isEmpty()) {
            value = (String)value + this.castableFrom.stream().map(Object::toString).collect(Collectors.joining(", ", ":castableFrom(", ")"));
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeVariableConstraint that = (TypeVariableConstraint)o;
        return this.comparableRequired == that.comparableRequired && this.orderableRequired == that.orderableRequired && Objects.equals(this.name, that.name) && Objects.equals(this.variadicBound, that.variadicBound) && Objects.equals(this.castableTo, that.castableTo) && Objects.equals(this.castableFrom, that.castableFrom);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comparableRequired, this.orderableRequired, this.variadicBound, this.castableTo, this.castableFrom);
    }

    public static TypeVariableConstraint typeVariable(String name) {
        return TypeVariableConstraint.builder(name).build();
    }

    public static TypeVariableConstraintBuilder builder(String name) {
        return new TypeVariableConstraintBuilder(name);
    }

    @JsonCreator
    @Deprecated
    @DoNotCall
    public static TypeVariableConstraint fromJson(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired, @JsonProperty(value="orderableRequired") boolean orderableRequired, @JsonProperty(value="variadicBound") Optional<String> variadicBound, @JsonProperty(value="castableTo") Set<TypeSignature> castableTo, @JsonProperty(value="castableFrom") Set<TypeSignature> castableFrom) {
        return new TypeVariableConstraint(name, comparableRequired, orderableRequired, variadicBound, castableTo, castableFrom);
    }

    public static class TypeVariableConstraintBuilder {
        private final String name;
        private boolean comparableRequired;
        private boolean orderableRequired;
        private String variadicBound;
        private final Set<TypeSignature> castableTo = new HashSet<TypeSignature>();
        private final Set<TypeSignature> castableFrom = new HashSet<TypeSignature>();

        private TypeVariableConstraintBuilder(String name) {
            this.name = name;
        }

        public TypeVariableConstraintBuilder comparableRequired() {
            this.comparableRequired = true;
            return this;
        }

        public TypeVariableConstraintBuilder orderableRequired() {
            this.orderableRequired = true;
            return this;
        }

        public TypeVariableConstraintBuilder variadicBound(String variadicBound) {
            this.variadicBound = variadicBound;
            return this;
        }

        public TypeVariableConstraintBuilder castableTo(Type type) {
            return this.castableTo(type.getTypeSignature());
        }

        public TypeVariableConstraintBuilder castableTo(TypeSignature type) {
            this.castableTo.add(type);
            return this;
        }

        public TypeVariableConstraintBuilder castableFrom(Type type) {
            return this.castableFrom(type.getTypeSignature());
        }

        public TypeVariableConstraintBuilder castableFrom(TypeSignature type) {
            this.castableFrom.add(type);
            return this;
        }

        public TypeVariableConstraint build() {
            return new TypeVariableConstraint(this.name, this.comparableRequired, this.orderableRequired, Optional.ofNullable(this.variadicBound), this.castableTo, this.castableFrom);
        }
    }
}

