/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ConstantProperty;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.connector.SortOrder;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class SortingProperty<E>
implements LocalProperty<E> {
    private final E column;
    private final SortOrder order;

    @JsonCreator
    public SortingProperty(@JsonProperty(value="column") E column, @JsonProperty(value="order") SortOrder order) {
        Objects.requireNonNull(column, "column is null");
        Objects.requireNonNull(order, "order is null");
        this.column = column;
        this.order = order;
    }

    @Override
    public boolean isOrderSensitive() {
        return true;
    }

    @JsonProperty
    public E getColumn() {
        return this.column;
    }

    @Override
    public Set<E> getColumns() {
        return Collections.singleton(this.column);
    }

    @JsonProperty
    public SortOrder getOrder() {
        return this.order;
    }

    @Override
    public <T> Optional<LocalProperty<T>> translate(Function<E, Optional<T>> translator) {
        return translator.apply(this.column).map(translated -> new SortingProperty<Object>(translated, this.order));
    }

    @Override
    public boolean isSimplifiedBy(LocalProperty<E> known) {
        return known instanceof ConstantProperty || known.equals(this);
    }

    public String toString() {
        String ordering = "";
        String nullOrdering = switch (this.order) {
            default -> throw new MatchException(null, null);
            case SortOrder.ASC_NULLS_FIRST -> {
                ordering = "\u2191";
                yield "\u2190";
            }
            case SortOrder.ASC_NULLS_LAST -> {
                ordering = "\u2191";
                yield "\u2192";
            }
            case SortOrder.DESC_NULLS_FIRST -> {
                ordering = "\u2193";
                yield "\u2190";
            }
            case SortOrder.DESC_NULLS_LAST -> {
                ordering = "\u2193";
                yield "\u2192";
            }
        };
        return "S" + ordering + nullOrdering + "(" + String.valueOf(this.column) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortingProperty that = (SortingProperty)o;
        return Objects.equals(this.column, that.column) && this.order == that.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.order});
    }
}

