/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import java.util.List;
import java.util.Map;

public interface ConnectorSplit {
    default public boolean isRemotelyAccessible() {
        return true;
    }

    default public List<HostAddress> getAddresses() {
        if (!this.isRemotelyAccessible()) {
            throw new IllegalStateException("getAddresses must be implemented when for splits with isRemotelyAccessible=false");
        }
        return List.of();
    }

    @JsonIgnore
    default public Map<String, String> getSplitInfo() {
        return Map.of();
    }

    @Deprecated(forRemoval=true)
    @JsonIgnore
    default public Object getInfo() {
        throw new UnsupportedOperationException("getInfo is deprecated and will be removed in the future. Use getSplitInfo instead.");
    }

    default public SplitWeight getSplitWeight() {
        return SplitWeight.standard();
    }

    default public long getRetainedSizeInBytes() {
        throw new UnsupportedOperationException("This connector does not provide memory accounting capabilities for ConnectorSplit");
    }
}

