/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics;

import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public class LongStatistics
extends Statistics<Long> {
    private static final PrimitiveType DEFAULT_FAKE_TYPE = (PrimitiveType)Types.optional(PrimitiveType.PrimitiveTypeName.INT64).named("fake_int64_type");
    private long max;
    private long min;

    @Deprecated
    public LongStatistics() {
        this(DEFAULT_FAKE_TYPE);
    }

    LongStatistics(PrimitiveType type) {
        super(type);
    }

    private LongStatistics(LongStatistics other) {
        super(other.type());
        if (other.hasNonNullValue()) {
            this.initializeStats(other.min, other.max);
        }
        this.setNumNulls(other.getNumNulls());
    }

    @Override
    public void updateStats(long value) {
        if (!this.hasNonNullValue()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        LongStatistics longStats = (LongStatistics)stats;
        if (!this.hasNonNullValue()) {
            this.initializeStats(longStats.getMin(), longStats.getMax());
        } else {
            this.updateStats(longStats.getMin(), longStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToLong(maxBytes);
        this.min = BytesUtils.bytesToLong(minBytes);
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.longToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.longToBytes(this.min);
    }

    @Override
    String stringify(Long value) {
        return this.stringifier.stringify(value);
    }

    @Override
    public boolean isSmallerThan(long size) {
        return !this.hasNonNullValue() || 16L < size;
    }

    public void updateStats(long min_value, long max_value) {
        if (this.comparator().compare(this.min, min_value) > 0) {
            this.min = min_value;
        }
        if (this.comparator().compare(this.max, max_value) < 0) {
            this.max = max_value;
        }
    }

    public void initializeStats(long min_value, long max_value) {
        this.min = min_value;
        this.max = max_value;
        this.markAsNotEmpty();
    }

    @Override
    public Long genericGetMin() {
        return this.min;
    }

    @Override
    public Long genericGetMax() {
        return this.max;
    }

    @Override
    public int compareMinToValue(long value) {
        return this.comparator().compare(this.min, value);
    }

    @Override
    public int compareMaxToValue(long value) {
        return this.comparator().compare(this.max, value);
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public void setMinMax(long min, long max) {
        this.max = max;
        this.min = min;
        this.markAsNotEmpty();
    }

    public LongStatistics copy() {
        return new LongStatistics(this);
    }
}

