/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

public class AlterDatabaseHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        if (!context.isTableNameEmpty()) {
            throw new SemanticException("Alter Database are not supported for table-level replication");
        }
        AlterDatabaseMessage msg = this.deserializer.getAlterDatabaseMessage(context.dmd.getPayload());
        String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
        try {
            AlterDatabaseDesc alterDbDesc;
            Database oldDb = msg.getDbObjBefore();
            Database newDb = msg.getDbObjAfter();
            if (oldDb.getOwnerType() == newDb.getOwnerType() && oldDb.getOwnerName().equalsIgnoreCase(newDb.getOwnerName())) {
                HashMap<String, String> newDbProps = new HashMap<String, String>();
                Map<String, String> dbProps = newDb.getParameters();
                for (Map.Entry<String, String> entry : dbProps.entrySet()) {
                    String key = entry.getKey();
                    if (key.startsWith("bootstrap.dump.state.") || key.equals(ReplicationSpec.KEY.CURR_STATE_ID.toString()) || key.equals("hive.repl.ckpt.key") || key.equals("repl.source.for")) continue;
                    newDbProps.put(key, entry.getValue());
                }
                alterDbDesc = new AlterDatabaseDesc(actualDbName, newDbProps, context.eventOnlyReplicationSpec());
            } else {
                alterDbDesc = new AlterDatabaseDesc(actualDbName, new PrincipalDesc(newDb.getOwnerName(), newDb.getOwnerType()), context.eventOnlyReplicationSpec());
            }
            Task<DDLWork> alterDbTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.readEntitySet, (HashSet<WriteEntity>)this.writeEntitySet, alterDbDesc), context.hiveConf);
            context.log.debug("Added alter database task : {}:{}", (Object)alterDbTask.getId(), (Object)actualDbName);
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, null, null);
            return Collections.singletonList(alterDbTask);
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)e : new SemanticException("Error reading message members", e);
        }
    }
}

