/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.DefaultBucketMatcher;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;

public final class SparkSortMergeJoinFactory {
    private SparkSortMergeJoinFactory() {
    }

    public static void annotateMapWork(GenSparkProcContext context, MapWork mapWork, SMBMapJoinOperator smbMapJoinOp, TableScanOperator ts, boolean local) throws SemanticException {
        SparkSortMergeJoinFactory.initSMBJoinPlan(context, mapWork, ts, local);
        SparkSortMergeJoinFactory.setupBucketMapJoinInfo(mapWork, smbMapJoinOp);
    }

    private static void setupBucketMapJoinInfo(MapWork plan, SMBMapJoinOperator currMapJoinOp) {
        Map<String, Map<String, List<String>>> aliasBucketFileNameMapping;
        if (currMapJoinOp != null && (aliasBucketFileNameMapping = ((SMBJoinDesc)currMapJoinOp.getConf()).getAliasBucketFileNameMapping()) != null) {
            MapredLocalWork localPlan = plan.getMapRedLocalWork();
            if (localPlan == null) {
                localPlan = ((SMBJoinDesc)currMapJoinOp.getConf()).getLocalWork();
            } else {
                MapredLocalWork smbLocalWork = ((SMBJoinDesc)currMapJoinOp.getConf()).getLocalWork();
                if (smbLocalWork != null) {
                    localPlan.getAliasToFetchWork().putAll(smbLocalWork.getAliasToFetchWork());
                    localPlan.getAliasToWork().putAll(smbLocalWork.getAliasToWork());
                }
            }
            if (localPlan == null) {
                return;
            }
            plan.setMapRedLocalWork(null);
            ((SMBJoinDesc)currMapJoinOp.getConf()).setLocalWork(localPlan);
            BucketMapJoinContext bucketMJCxt = new BucketMapJoinContext();
            localPlan.setBucketMapjoinContext(bucketMJCxt);
            bucketMJCxt.setAliasBucketFileNameMapping(aliasBucketFileNameMapping);
            bucketMJCxt.setBucketFileNameMapping(((SMBJoinDesc)currMapJoinOp.getConf()).getBigTableBucketNumMapping());
            localPlan.setInputFileChangeSensitive(true);
            bucketMJCxt.setMapJoinBigTableAlias(((SMBJoinDesc)currMapJoinOp.getConf()).getBigTableAlias());
            bucketMJCxt.setBucketMatcherClass(DefaultBucketMatcher.class);
            bucketMJCxt.setBigTablePartSpecToFileMapping(((SMBJoinDesc)currMapJoinOp.getConf()).getBigTablePartSpecToFileMapping());
            plan.setUseBucketizedHiveInputFormat(true);
        }
    }

    private static void initSMBJoinPlan(GenSparkProcContext opProcCtx, MapWork mapWork, TableScanOperator currentRootOperator, boolean local) throws SemanticException {
        String currAliasId = SparkSortMergeJoinFactory.findAliasId(opProcCtx, currentRootOperator);
        GenMapRedUtils.setMapWork(mapWork, opProcCtx.parseContext, opProcCtx.inputs, null, currentRootOperator, currAliasId, opProcCtx.conf, local);
    }

    private static String findAliasId(GenSparkProcContext opProcCtx, TableScanOperator ts) {
        for (String alias : opProcCtx.topOps.keySet()) {
            if (opProcCtx.topOps.get(alias) != ts) continue;
            return alias;
        }
        return null;
    }
}

