/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;

final class ObjectCasts {
    private ObjectCasts() {
    }

    public static boolean castToBoolean(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        try {
            if (x instanceof Number) {
                return ((Number)x).intValue() != 0;
            }
            if (x instanceof String) {
                switch (((String)x).toLowerCase(Locale.ENGLISH)) {
                    case "0": 
                    case "false": {
                        return false;
                    }
                    case "1": 
                    case "true": {
                        return true;
                    }
                }
                throw new IllegalArgumentException("Invalid boolean value: " + x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static byte castToByte(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return (byte)((Boolean)x != false ? 1 : 0);
        }
        try {
            if (x instanceof Number) {
                return ((Number)x).byteValue();
            }
            if (x instanceof String) {
                return Byte.parseByte((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static short castToShort(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return (short)((Boolean)x != false ? 1 : 0);
        }
        try {
            if (x instanceof Number) {
                return ((Number)x).shortValue();
            }
            if (x instanceof String) {
                return Short.parseShort((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static int castToInt(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        try {
            if (x instanceof Number) {
                return ((Number)x).intValue();
            }
            if (x instanceof String) {
                return Integer.parseInt((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static long castToLong(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        try {
            if (x instanceof Number) {
                return ((Number)x).longValue();
            }
            if (x instanceof String) {
                return Long.parseLong((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static float castToFloat(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        try {
            if (x instanceof Number) {
                return ((Number)x).floatValue();
            }
            if (x instanceof String) {
                return Float.parseFloat((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static double castToDouble(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        try {
            if (x instanceof Number) {
                return ((Number)x).doubleValue();
            }
            if (x instanceof String) {
                return Double.parseDouble((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static BigDecimal castToBigDecimal(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Boolean) {
            return BigDecimal.valueOf((Boolean)x != false ? 1L : 0L);
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        try {
            if (x instanceof Byte || x instanceof Short || x instanceof Integer || x instanceof Long) {
                return BigDecimal.valueOf(((Number)x).longValue());
            }
            if (x instanceof Float || x instanceof Double) {
                return BigDecimal.valueOf(((Number)x).doubleValue());
            }
            if (x instanceof String) {
                return new BigDecimal((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static byte[] castToBinary(Object x, int targetSqlType) throws SQLException {
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof String) {
            return ((String)x).getBytes(StandardCharsets.UTF_8);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static Date castToDate(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Date) {
            return (Date)x;
        }
        if (x instanceof java.util.Date) {
            return new Date(((java.util.Date)x).getTime());
        }
        if (x instanceof LocalDate) {
            return Date.valueOf((LocalDate)x);
        }
        if (x instanceof LocalDateTime) {
            return Date.valueOf(((LocalDateTime)x).toLocalDate());
        }
        try {
            if (x instanceof String) {
                return Date.valueOf((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static Time castToTime(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Time) {
            return (Time)x;
        }
        if (x instanceof java.util.Date) {
            return new Time(((java.util.Date)x).getTime());
        }
        if (x instanceof LocalTime) {
            return Time.valueOf((LocalTime)x);
        }
        if (x instanceof LocalDateTime) {
            return Time.valueOf(((LocalDateTime)x).toLocalTime());
        }
        try {
            if (x instanceof String) {
                return Time.valueOf((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    public static Timestamp castToTimestamp(Object x, int targetSqlType) throws SQLException {
        if (x instanceof Timestamp) {
            return (Timestamp)x;
        }
        if (x instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)x).getTime());
        }
        if (x instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)x);
        }
        try {
            if (x instanceof String) {
                return Timestamp.valueOf((String)x);
            }
        }
        catch (RuntimeException e) {
            throw ObjectCasts.invalidConversion(x, targetSqlType, e);
        }
        throw ObjectCasts.invalidConversion(x, targetSqlType);
    }

    private static SQLException invalidConversion(Object x, int sqlType) {
        return ObjectCasts.invalidConversion(x, sqlType, null);
    }

    private static SQLException invalidConversion(Object x, int sqlType, Exception e) {
        return new SQLException(String.format("Cannot convert instance of %s to SQL type %s", x.getClass().getName(), sqlType), e);
    }
}

