/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HashedBytes {
    private final byte[] bytes;
    private final int hashCode;

    public HashedBytes(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = Bytes.hashCode((byte[])bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashedBytes other = (HashedBytes)obj;
        return this.hashCode == other.hashCode && Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return Bytes.toStringBinary((byte[])this.bytes);
    }
}

