/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ServerTask;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.UserMetrics;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface ServerMetrics {
    public ServerName getServerName();

    default public int getVersionNumber() {
        return 0;
    }

    default public String getVersion() {
        return "0.0.0";
    }

    public long getRequestCountPerSecond();

    public long getRequestCount();

    public Size getUsedHeapSize();

    public Size getMaxHeapSize();

    public int getInfoServerPort();

    public List<ReplicationLoadSource> getReplicationLoadSourceList();

    public Map<String, List<ReplicationLoadSource>> getReplicationLoadSourceMap();

    @Nullable
    public ReplicationLoadSink getReplicationLoadSink();

    public Map<byte[], RegionMetrics> getRegionMetrics();

    public Map<byte[], UserMetrics> getUserMetrics();

    public Set<String> getCoprocessorNames();

    public long getReportTimestamp();

    public long getLastReportTimestamp();

    @Nullable
    public List<ServerTask> getTasks();

    public Map<String, Integer> getRegionCachedInfo();
}

