/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class RemoveSCMRequest {
    private final String clusterId;
    private final String scmId;
    private final String ratisAddr;

    public RemoveSCMRequest(String clusterId, String scmId, String addr) {
        this.clusterId = clusterId;
        this.scmId = scmId;
        this.ratisAddr = addr;
    }

    public static RemoveSCMRequest getFromProtobuf(HddsProtos.RemoveScmRequestProto proto) {
        return new Builder().setClusterId(proto.getClusterId()).setScmId(proto.getScmId()).setRatisAddr(proto.getRatisAddr()).build();
    }

    public HddsProtos.RemoveScmRequestProto getProtobuf() {
        return HddsProtos.RemoveScmRequestProto.newBuilder().setClusterId(this.clusterId).setScmId(this.scmId).setRatisAddr(this.ratisAddr).build();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getScmId() {
        return this.scmId;
    }

    public String getRatisAddr() {
        return this.ratisAddr;
    }

    public static class Builder {
        private String clusterId;
        private String scmId;
        private String ratisAddr;

        public Builder setClusterId(String cid) {
            this.clusterId = cid;
            return this;
        }

        public Builder setScmId(String id) {
            this.scmId = id;
            return this;
        }

        public Builder setRatisAddr(String addr) {
            this.ratisAddr = addr;
            return this;
        }

        public RemoveSCMRequest build() {
            return new RemoveSCMRequest(this.clusterId, this.scmId, this.ratisAddr);
        }
    }
}

