/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.network.security.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidBestFitX509KeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpidBestFitX509KeyManager.class);
    private static final long SIX_HOURS = 21600000L;
    private final X509ExtendedKeyManager _delegate;
    private final String _defaultAlias;
    private final List<String> _aliases;

    public QpidBestFitX509KeyManager(String defaultAlias, URL keyStoreUrl, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithmName) throws GeneralSecurityException, IOException {
        KeyStore ks = SSLUtil.getInitializedKeyStore(keyStoreUrl, keyStorePassword, keyStoreType);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithmName);
        kmf.init(ks, keyStorePassword.toCharArray());
        ArrayList<String> aliases = new ArrayList<String>();
        for (String alias : Collections.list(ks.aliases())) {
            if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
            aliases.add(alias);
        }
        this._aliases = Collections.unmodifiableList(aliases);
        this._delegate = (X509ExtendedKeyManager)kmf.getKeyManagers()[0];
        this._defaultAlias = defaultAlias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this._defaultAlias == null ? this._delegate.chooseClientAlias(keyType, issuers, socket) : this._defaultAlias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this._delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this._delegate.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this._delegate.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this._delegate.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this._delegate.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this._defaultAlias == null ? this._delegate.chooseEngineClientAlias(keyType, issuers, engine) : this._defaultAlias;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        Date currentDate = new Date();
        List<SNIServerName> serverNames = engine.getSSLParameters().getServerNames();
        if (serverNames == null || serverNames.isEmpty()) {
            return this.getDefaultServerAlias(keyType, issuers, engine);
        }
        ArrayList<String> validAliases = new ArrayList<String>();
        ArrayList<String> invalidAliases = new ArrayList<String>();
        for (SNIServerName serverName : engine.getSSLParameters().getServerNames()) {
            if (!(serverName instanceof SNIHostName)) continue;
            for (String alias : this._aliases) {
                if (!keyType.equalsIgnoreCase(this.getPrivateKey(alias).getAlgorithm())) continue;
                X509Certificate[] certChain = this.getCertificateChain(alias);
                X509Certificate cert = certChain[0];
                if (!SSLUtil.checkHostname(((SNIHostName)serverName).getAsciiName(), cert)) continue;
                if (currentDate.after(cert.getNotBefore()) && currentDate.before(cert.getNotAfter())) {
                    validAliases.add(alias);
                    continue;
                }
                invalidAliases.add(alias);
            }
        }
        if (validAliases.isEmpty()) {
            if (invalidAliases.isEmpty()) {
                return this.getDefaultServerAlias(keyType, issuers, engine);
            }
            return (String)invalidAliases.get(0);
        }
        if (validAliases.size() > 1) {
            for (String alias : validAliases) {
                X509Certificate cert = this.getCertificateChain(alias)[0];
                if (currentDate.getTime() - cert.getNotBefore().getTime() <= 21600000L || cert.getNotAfter().getTime() - currentDate.getTime() <= 21600000L) continue;
                return alias;
            }
        }
        return (String)validAliases.get(0);
    }

    private String getDefaultServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this._defaultAlias != null) {
            return this._defaultAlias;
        }
        return this._delegate.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

